/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeProjectScpVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeProjectBelongDeptSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 项目档案所属部门表
 *
 * @author hgw
 * @date 2025-02-28 15:03:17
 */
@Mapper
public interface TEmployeeProjectBelongDeptMapper extends BaseMapper<TEmployeeProjectBelongDept> {
	/**
	 * 项目档案所属部门表简单分页查询
	 *
	 * @param tEmployeeProjectBelongDept 项目档案所属部门表
	 * @return
	 */
	IPage<EmployeeProjectScpVO> getTEmployeeProjectBelongDeptPage(Page<EmployeeProjectScpVO> page
			, @Param("tEmployeeProjectBelongDept") TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	// 导出的条数
	int getTEmployeeProjectBelongDeptCount(
			@Param("tEmployeeProjectBelongDept") TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	// 导出的数据
	List<EmployeeProjectScpVO> getTEmployeeProjectBelongDeptList(
			@Param("tEmployeeProjectBelongDept") TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	// 获取部门下花名册总数
	int getDeptCount(@Param("tEmployeeProjectBelongDept") TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	// 根据权限获取对应部门ID下的花名册总数Map
	List<TEmployeeProjectBelongDeptSearchVo> getDeptCountMap(@Param("deptId") String deptId,@Param("departIdSet") Set<String> departIdSet);

	// 没有关联部门的花名册总数
	int getNoneDeptCount(@Param("tEmployeeProjectBelongDept") TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

}
