package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * @Author fxj
 * @Description 附件信息表
 * @Date 11:07 2022/6/22
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_atta_info")
@Tag(name = "附件信息表")
public class TAttaInfo  extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 资源名称
     */
    @NotBlank(message = "资源名称不能为空")
    @Length(max = 50, message = "资源名称不能超过50个字符")
    @Schema(description = "资源名称")
    private String attaName;
    /**
     * 资源地址
     */
    @NotBlank(message = "资源地址不能为空")
    @Length(max = 100, message = "资源地址不能超过100个字符")
    @Schema(description = "资源地址")
    private String attaSrc;
    /**
     * 资源大小
     */
    @Schema(description = "资源大小")
    private Long attaSize;
    /**
     * 资源类型
     */
    @Length(max = 10, message = "资源类型不能超过10个字符")
    @Schema(description = "资源类型")
    private String attaType;
    /**
     * 关系类型(0客户附件1联系人附件2跟进记录附件3合同附件4合同归档附件5报价单6招投标7业务评估8二维码9身份证 10 户口本
	 * ；21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文件)；0（最高教育经历)；2（执业资格证书)；24 身份证国徽
	 * 25 户口本本人页26学信27预入职其他附件28户配置 31入离职登记身份证正面 32入离职登记身份证反面
	 * 41（瓜子申明签名）；42（瓜子确认签名）；43（瓜子pdf文件)
	 * CONTRACT（合同） NID_A（证件正面） NID_B（证件反面） BANK_FLOW（银行流水）
	 * EDUQ（学历） DEGRE（学位） PHOTO（头像） BANK_A（银行卡正面）
	 * BANK_B（银行卡反面） LEAVE_PRO（离职证明） EXAM_RPT（体检报告）
     */
    @NotBlank(message = "关系类型不能为空")
    @Length(max = 20, message = "关系类型不能超过2个字符")
    @Schema(description = "关系类型(0客户附件1联系人附件2跟进记录附件3合同附件4合同归档附件5报价单6招投标7业务评估8二维码9身份证 10 户口本；21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文件)；0（最高教育经历)；2（执业资格证书)；24 身份证国徽 25 户口本本人页26学信28户配置 31入离职登记身份证正面 32入离职登记身份证反面)")
    private String relationType;
    /**
     * 实体id和关系类型共同确定附件所属(9、10、21、22、23、24、25存项目档案id，0、2、26存附属表id)
     */
    @NotBlank(message = "实体id和关系类型共同确定附件所属不能为空")
    @Length(max = 32, message = "实体id和关系类型共同确定附件所属不能超过32个字符")
    @Schema(description = "实体id和关系类型共同确定附件所属")
    private String domainId;

	/**
	 * 地址URL
	 */
	@Length(max = 100, message = "地址URL不能超过100个字符")
	@Schema(description = "地址URL")
	@TableField(exist = false)
	private String attaUrl;
	/**
	 * 附件变更类型：0 新增 1 更新 2 删除 3 不变 档案编辑附件时需要告知后端是增加还是减少
	 */
	@TableField(exist = false)
	private String handleType;

	/**
	 * 其他分租名称
	 */
	@TableField(exist = false)
	private String groupName;
}
