
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitor;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@Data
public class TCompleteMonitorSearchVo extends TCompleteMonitor {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;

	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

	@Schema(description = "在项人数区间开始")
	private Integer inusePersonNumStart;

	@Schema(description = "在项人数区间结束")
	private Integer inusePersonNumEnd;

}
