package com.yifu.cloud.plus.v1.business.entity.salary;

import cn.hutool.core.date.DatePattern;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


/**
 * B端-薪酬主表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_salary")
@Schema(description = "B端-薪酬主表")
public class TBusSalary extends Model<TBusSalary> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 电信工号
      */
     @NotBlank(message = "电信工号不能为空")
     @Length(max = 50, message = "电信工号不能超过50个字符")
     @ExcelAttribute(name = "电信工号", isNotEmpty = true, errorInfo = "电信工号不能为空", maxLength = 50)
     @Schema(description = "电信工号")
     private String teleNo;
     /**
      * 姓名
      */
     @Length(max = 50, message = "姓名不能超过50个字符")
     @ExcelAttribute(name = "姓名", maxLength = 50)
     @Schema(description = "姓名")
     private String empName;
     /**
      * 身份证号
      */
     @Length(max = 50, message = "身份证号不能超过50个字符")
     @ExcelAttribute(name = "身份证号", maxLength = 50)
     @Schema(description = "身份证号")
     private String empIdCard;
     /**
      * 部门id
      */
     @ExcelAttribute(name = "部门id", maxLength = 11)
     @Schema(description = "部门id")
     private Integer deptId;
     /**
      * 部门Level
      */
     @ExcelAttribute(name = "部门Level")
     @Schema(description = "部门Level")
     private Integer deptLevel;
     /**
      * 所属部门
      */
     @NotBlank(message = "所属部门不能为空")
     @Length(max = 100, message = "所属部门不能超过100个字符")
     @ExcelAttribute(name = "所属部门", isNotEmpty = true, errorInfo = "所属部门不能为空", maxLength = 100)
     @Schema(description = "所属部门")
     private String deptName;
     /**
      * 部门tree
      */
     @Length(max = 200, message = "部门tree不能超过200个字符")
     @ExcelAttribute(name = "部门tree", maxLength = 200)
     @Schema(description = "部门tree")
     private String deptTreeLogo;
     /**
      * 岗位
      */
     @Length(max = 50, message = "岗位不能超过50个字符")
     @ExcelAttribute(name = "岗位", maxLength = 50)
     @Schema(description = "岗位")
     private String post;
     /**
      * 工资月份
      */
     @NotBlank(message = "工资月份不能为空")
     @Length(max = 6, message = "工资月份不能超过6个字符")
     @ExcelAttribute(name = "工资月份", isDate = true, errorInfo = "工资月份不能为空", maxLength = 6, dateFormat = "yyyyMM")
     @Schema(description = "工资月份")
     private String salaryMonth;
     /**
      * 薪酬应发
      */
     @ExcelAttribute(name = "薪酬应发", maxLength = 9)
     @Schema(description = "薪酬应发")
     private BigDecimal relaySalary;
     /**
      * 激励应发
      */
     @ExcelAttribute(name = "激励应发", maxLength = 9)
     @Schema(description = "激励应发")
     private BigDecimal relayIncent;
     /**
      * 其他应发
      */
     @ExcelAttribute(name = "其他应发", maxLength = 9)
     @Schema(description = "其他应发")
     private BigDecimal relayOther;
     /**
      * 应发合计
      */
     @NotNull(message = "应发合计不能为空")
     @ExcelAttribute(name = "应发合计", isNotEmpty = true, errorInfo = "应发合计不能为空", maxLength = 9)
     @Schema(description = "应发合计")
     private BigDecimal relaySum;
     /**
      * 代扣个人社保
      */
     @ExcelAttribute(name = "代扣个人社保", maxLength = 9)
     @Schema(description = "代扣个人社保")
     private BigDecimal withholidPersonSocial;
     /**
      * 代扣个人公积金
      */
     @ExcelAttribute(name = "代扣个人公积金", maxLength = 9)
     @Schema(description = "代扣个人公积金")
     private BigDecimal withholidPersonFund;
     /**
      * 代扣个税
      */
     @ExcelAttribute(name = "代扣个税", maxLength = 9)
     @Schema(description = "代扣个税")
     private BigDecimal withholidPersonTax;
     /**
      * 其他应扣————其他扣款
      * 2021-9-17 15:39:02 张倩倩要求改名为 其他扣款
      */
     @ExcelAttribute(name = "其他扣款", maxLength = 9)
     @Schema(description = "其他扣款")
     private BigDecimal withholidOther;
     /**
      * 扣款合计
      */
     @NotNull(message = "扣款合计不能为空")
     @ExcelAttribute(name = "扣款合计", isNotEmpty = true, errorInfo = "扣款合计不能为空", maxLength = 9)
     @Schema(description = "扣款合计")
     private BigDecimal withholidSum;
     /**
      * 实发工资
      */
     @NotNull(message = "实发工资不能为空")
     @ExcelAttribute(name = "实发工资", isNotEmpty = true, errorInfo = "实发工资不能为空", maxLength = 9)
     @Schema(description = "实发工资")
     private BigDecimal actualSalary;
     /**
      * 单位社保
      */
     @ExcelAttribute(name = "单位社保", maxLength = 9)
     @Schema(description = "单位社保")
     private BigDecimal unitSocial;
     /**
      * 单位公积金
      */
     @ExcelAttribute(name = "单位公积金" , maxLength = 9)
     @Schema(description = "单位公积金")
     private BigDecimal unitFund;
     /**
      * 创建人id
      */
     @NotBlank(message = "创建人id不能为空")
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;

     @Schema(description = "工资附加项")
     @TableField(exist = false)
     List<TBusSalaryItem> bisList = new ArrayList<>();

     @Schema(description = "工资附加项-所有表头")
     @TableField(exist = false)
     Set<String> titleSet = new HashSet<>();

     /**
      * id，导出使用
      */
     @TableField(exist = false)
     String idStr;
}
