package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description 投保成功/退回/减员办理导入校验
 * @date 2022-08-22 10:15:19
 */
@Data
@Tag(name = "投保成功/退回/减员办理导入参数")
public class InsuranceHandleImportParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 商险id
	 */
	@Schema(description = "商险id")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号码
	 */
	@Schema(description = "员工身份证号码")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始日期
	 */
	@Schema(description = "保单开始日期")
	private String policyStart;
	/**
	 * 保单结束日期
	 */
	@Schema(description = "保单结束日期")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 办理类型
	 */
	@Schema(description = "办理类型")
	private String handType;

	/**
	 * 办理意见
	 */
	@Schema(description = "办理意见")
	private String remark;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 错误标志 0 正确 1错误
	 */
	@Schema(description = "错误标志")
	private String flag;
}
