/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmpModLog;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryEmpModLogSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 薪资人员档案变更记录
 *
 * @author fxj
 * @date 2023-10-11 17:48:31
 */
@Mapper
public interface TSalaryEmpModLogMapper extends BaseMapper<TSalaryEmpModLog> {
    /**
     * 薪资人员档案变更记录简单分页查询
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return
     */
    IPage<TSalaryEmpModLog> getTSalaryEmpModLogPage(Page<TSalaryEmpModLog> page, @Param("tSalaryEmpModLog") TSalaryEmpModLogSearchVo tSalaryEmpModLog);
}
