/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;
import com.yifu.cloud.plus.v1.yifu.social.service.SysPayProportionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 公积金政策对应的缴费比例表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/syspayproportion")
@Tag(name = "公积金政策对应的缴费比例表管理")
public class SysPayProportionController {

	private final SysPayProportionService sysPayProportionService;


	/**
	 * 简单分页查询
	 *
	 * @param page             分页对象
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page")
	public R<IPage<SysPayProportion>> getSysPayProportionPage(Page<SysPayProportion> page, SysPayProportion sysPayProportion) {
		return new R<>(sysPayProportionService.getSysPayProportionPage(page, sysPayProportion));
	}

	/**
	 * 不分页查询
	 *
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('social_syspayproportion_get')" )
	public R<List<SysPayProportion>> getSysPayProportionNoPage(@RequestBody SysPayProportion sysPayProportion) {
		return R.ok(sysPayProportionService.list(Wrappers.query(sysPayProportion).orderByDesc(CommonConstants.CREATE_TIME)));
	}

	/**
	 * 通过id查询公积金政策对应的缴费比例表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_syspayproportion_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_syspayproportion_get')")
	public R<SysPayProportion> getById(@PathVariable("id") String id) {
		return R.ok(sysPayProportionService.getById(id));
	}

	/**
	 * 新增公积金政策对应的缴费比例表
	 *
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return R
	 */
	@Operation(summary = "新增公积金政策对应的缴费比例表", description = "新增公积金政策对应的缴费比例表：hasPermission('social_syspayproportion_add')")
	@SysLog("新增公积金政策对应的缴费比例表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('social_syspayproportion_add')")
	public R<Boolean> save(@RequestBody SysPayProportion sysPayProportion) {
		return R.ok(sysPayProportionService.save(sysPayProportion));
	}

	/**
	 * 修改公积金政策对应的缴费比例表
	 *
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return R
	 */
	@Operation(summary = "修改公积金政策对应的缴费比例表", description = "修改公积金政策对应的缴费比例表：hasPermission('social_syspayproportion_edit')")
	@SysLog("修改公积金政策对应的缴费比例表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('social_syspayproportion_edit')")
	public R<Boolean> updateById(@RequestBody SysPayProportion sysPayProportion) {
		return R.ok(sysPayProportionService.updateById(sysPayProportion));
	}

	/**
	 * 通过id删除公积金政策对应的缴费比例表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除公积金政策对应的缴费比例表", description = "通过id删除公积金政策对应的缴费比例表：hasPermission('social_syspayproportion_del')")
	@SysLog("通过id删除公积金政策对应的缴费比例表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_syspayproportion_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(sysPayProportionService.removeById(id));
	}

}
