/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 法大大专业版模板映射表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
@TableName("t_fasc_template_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大专业版模板映射表")
public class TFascTemplateDetail extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 模板ID
	 */
	@ExcelAttribute(name = "模板ID", isNotEmpty = true, errorInfo = "模板ID不能为空", maxLength = 100)
	@NotBlank(message = "模板ID不能为空")
	@Length(max = 100, message = "模板ID不能超过100个字符")
	@ExcelProperty("模板ID")
	@Schema(description = "模板ID")
	private String signTemplateId;
	/**
	 * 法大大文档ID
	 */
	@ExcelAttribute(name = "法大大文档ID", maxLength = 100)
	@Length(max = 100, message = "法大大文档ID不能超过100个字符")
	@ExcelProperty("法大大文档ID")
	@Schema(description = "法大大文档ID")
	private String fascDocId;
	/**
	 * 法大大字段
	 */
	@ExcelAttribute(name = "法大大字段", maxLength = 100)
	@Length(max = 100, message = "法大大字段不能超过100个字符")
	@ExcelProperty("法大大字段")
	@Schema(description = "法大大字段")
	private String fascField;
	/**
	 * 法大大字段ID
	 */
	@ExcelAttribute(name = "法大大字段ID", maxLength = 100)
	@Length(max = 100, message = "法大大字段ID不能超过100个字符")
	@ExcelProperty("法大大字段ID")
	@Schema(description = "法大大字段ID")
	private String fascFieldId;
	/**
	 * 是否必填0否1是
	 */
	@ExcelAttribute(name = "是否必填0否1是", maxLength = 1 , isDataId = true, readConverterExp = "0=否,1=是")
	@Length(max = 1, message = "是否必填0否1是不能超过1个字符")
	@ExcelProperty("是否必填0否1是")
	@Schema(description = "是否必填0否1是")
	private String isMust;
	/**
	 * 是否删除0否1是
	 */
	@ExcelAttribute(name = "是否删除0否1是", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@Length(max = 1, message = "是否删除0否1是不能超过1个字符")
	@ExcelProperty("是否删除0否1是")
	@Schema(description = "是否删除0否1是")
	private String deleteFlag;
	/**
	 * 皖信字段
	 */
	@ExcelAttribute(name = "皖信字段", maxLength = 100)
	@Length(max = 100, message = "皖信字段不能超过100个字符")
	@ExcelProperty("皖信字段")
	@Schema(description = "皖信字段")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String hrField;
	/**
	 * 皖信字段ID
	 */
	@ExcelAttribute(name = "皖信字段ID", maxLength = 100)
	@Length(max = 100, message = "皖信字段ID不能超过100个字符")
	@ExcelProperty("皖信字段ID")
	@Schema(description = "皖信字段ID")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String hrFieldId;
	/**
	 * 是否已配置0未配置1已配置
	 */
	@ExcelAttribute(name = "是否已配置", maxLength = 3, isDataId = true, readConverterExp = "0=未配置,1=已配置")
	@Length(max = 3, message = "是否已配置不能超过3个字符")
	@ExcelProperty("是否已配置")
	@Schema(description = "是否已配置0未配置1已配置")
	private String isEdit;

	@TableField(exist = false)
	@Schema(description = "模版名称")
	private String signTemplateName;

	// 模板状态: invalid: 停用;valid: 启用;creating：草稿
	@TableField(exist = false)
	@Schema(description = "模版状态")
	private String signTemplateStatus;

	@TableField(exist = false)
	@Schema(description = "对应皖信合同类型")
	private String contractType;

	// 合同类型是否配置 空（空值），“是”（1），“否”（0）
	@TableField(exist = false)
	@Schema(description = "合同类型是否配置")
	private String haveContractType;

}
