/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascHrField;

import java.util.List;
import java.util.Map;

/**
 * 法大大专业版皖信字段表
 *
 * @author hgw
 * @date 2025-09-30 16:29:27
 */
public interface TFascHrFieldService extends IService<TFascHrField> {
	/**
	 * 法大大专业版皖信字段表简单分页查询
	 *
	 * @param tFascHrField 法大大专业版皖信字段表
	 * @return
	 */
	IPage<TFascHrField> getTFascHrFieldPage(Page<TFascHrField> page, TFascHrField tFascHrField);

	List<TFascHrField> noPageDiy(TFascHrField tFascHrField);

	// 返回：合同类型，值为字段ID+_+字段 的Map
	Map<String, Map<String, String>> getFieldAllMap(TFascHrField tFascHrField);
}
