package com.yifu.cloud.plus.v1.business.controller.vacation;

import com.yifu.cloud.plus.v1.business.dto.vacation.AddVacationMonitorClearLogDTO;
import com.yifu.cloud.plus.v1.business.service.vacation.TVacationMonitorClearLogService;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationMonitorClearLogVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @description: 假期监控清零日志表 controller
 * @author: huyc
 * @date: 2023/1/13
*/
@RestController
@AllArgsConstructor
@RequestMapping("/vacationMonitorClearLog")
@Tag(name = "假期监控清零日志表相关api")
public class TVacationMonitorClearLogController {

    private final TVacationMonitorClearLogService tVacationMonitorClearLogService;

    /**
     * @description: 查询-列表: 查询当前年假所有清零记录
     * @param vacationMonitorId 年假监控id
     * @return: R<List<TVacationMonitorClearLogVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "查询-列表: 查询当前年假所有清零记录", description = "查询-列表: 查询当前年假所有清零记录")
    @GetMapping("/getList")
    public R<List<TVacationMonitorClearLogVO>> getList(@RequestParam("vacationMonitorId") @Parameter(description = "年假监控id", required = true) String vacationMonitorId) {
        return this.tVacationMonitorClearLogService.getList(vacationMonitorId);
    }

    /**
     * @description: 清零说明: 记录年假清零说明
     * @param dto
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
	@Operation(summary = "清零说明: 记录年假清零说明", description = "清零说明: 记录年假清零说明")
	@PostMapping("/clearNote")
    public R<Boolean> clearNote(@RequestBody @Valid AddVacationMonitorClearLogDTO dto) {
        return this.tVacationMonitorClearLogService.clearNote(dto);
    }

}

