package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpShenhepeizhiService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpDivisionInfoVo;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 事业部审批配置
 * @author chenyuxi
 * @date 2025/1/15
 * @since 1.7.5
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpShenhepeizhi" )
@Tag(name = "事业部审批配置")
public class TEkpShenhepeizhiController {

	private final EkpShenhepeizhiService shenhepeizhiService;

	@Inner
	@PostMapping("/inner/getDivisionUsernameList")
	public EkpDivisionInfoVo getDivisionUsernameList(@RequestBody EkpDivisionInfoVo divisionInfoVo) {
		return shenhepeizhiService.getDivisionUsernameList(divisionInfoVo);
	}

}
