/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentDetail;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
@Mapper
public interface TAutoPaymentDetailMapper extends BaseMapper<TAutoPaymentDetail> {
	/**
	 * 自动化实缴记录表简单分页查询
	 *
	 * @param tAutoPaymentDetail 自动化实缴记录表
	 * @return
	 */
	IPage<TAutoPaymentDetail> getTAutoPaymentDetailPage(Page<TAutoPaymentDetail> page, @Param("tAutoPaymentDetail") TAutoPaymentDetail tAutoPaymentDetail);

	/**
	 * @param parentId
	 * @Description: 删除明细表
	 * @Author: hgw
	 * @Date: 2024/6/6 9:55
	 * @return: void
	 **/
	void deleteByParentId(@Param("parentId") String parentId, @Param("sourceType") int sourceType);

	List<TAutoPaymentDetail> getListByParentId(@Param("parentId") String parentId);

	int getCountByParentId(@Param("parentId") String parentId);

}
