package com.yifu.cloud.plus.v1.business.vo.settle;

import lombok.Getter;
import org.apache.commons.lang.StringUtils;

/**
 * @description: SettleAdditionTypeEnum 结算相关附件类型
 * @author: wangweiguo
 * @date: 2021/8/19
 */
@Getter
public enum SettleAdditionTypeEnum {

    SETTLE_RECORD("结算单", 0),
    PROVE_SOCIAL("流水证明_社保", 1),
    PROVE_FUND("流水证明_公积金", 2),
    PROVE_SALARY_RECORD("流水证明_代发工资单", 3),
    PROVE_MEAL_FEE("流水证明_餐补", 4),
    PROVE_GIFT_BAG("流水证明_春节大礼包", 5);

    private String typeName;

    private int type;

    SettleAdditionTypeEnum(String typeName, int type) {
        this.typeName = typeName;
        this.type = type;
    }

    public static SettleAdditionTypeEnum getTypeEnumByFileName(String fileName) {
        for (SettleAdditionTypeEnum setteAdditionTypeEnum : values()) {
            if (!StringUtils.contains(fileName, setteAdditionTypeEnum.typeName)) {
                continue;
            }
            return setteAdditionTypeEnum;
        }
        return null;
    }

}
