/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceAreaRes;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceAreaExportVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceAreaResSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商险地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:32:05
 */
@Mapper
public interface TInsuranceAreaResMapper extends BaseMapper<TInsuranceAreaRes> {
	/**
	 * 商险地市权限配置表简单分页查询
	 *
	 * @param tInsuranceAreaRes 商险地市权限配置表
	 * @return
	 */
	IPage<TInsuranceAreaRes> getTInsuranceAreaResPage(Page<TInsuranceAreaRes> page, @Param("tInsuranceAreaRes") TInsuranceAreaRes tInsuranceAreaRes);

	List<TInsuranceAreaExportVo> noPageDiy(@Param("tInsuranceAreaRes")TInsuranceAreaResSearchVo searchVo,
										   @Param("settleDomainIds")List<String> settleDomains,
										   @Param("idsStr") List<String> idsStr,
										   @Param("sql")String sql);

	int noPageCountDiy(@Param("tInsuranceAreaRes")TInsuranceAreaResSearchVo searchVo,
						@Param("settleDomainIds")List<String> settleDomains,
						@Param("idsStr") List<String> idsStr,
						@Param("sql")String sql);
}
