package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainRegistListVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ClientNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.ArchivesDaprUtil;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.UpmsDaprUtils;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.config.WxConfig;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TEmployeeInsurancePreMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.ScheduleService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TEmployeeInsurancePreService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class TEmployeeInsurancePreServiceImpl extends ServiceImpl<TEmployeeInsurancePreMapper, TEmployeeInsurancePre> implements TEmployeeInsurancePreService {

	@Autowired
	private ArchivesDaprUtil archivesDaprUtil;

	@Autowired
	@Lazy
	private TInsuranceDetailService detailService;

	@Autowired
	@Lazy
	private ScheduleService scheduleService;

	@Autowired
	private WxConfig wxConfig;

	@Autowired
	private UpmsDaprUtils upmsDaprUtils;

	/**
	 * 商险待办任务表简单分页查询
	 *
	 * @param tEmployeeInsurancePre 商险待办任务表
	 * @return
	 */
	@Override
	public IPage<TEmployeeInsurancePre> getTEmployeeInsurancePrePage(Page<TEmployeeInsurancePre> page, TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		if (null == tEmployeeInsurancePre.getStatusList()) {
			tEmployeeInsurancePre.setStatusList(CommonConstants.processListPreArchivesStatus);
		}
		//权限赋值
		initSearchVo(tEmployeeInsurancePre);
		return baseMapper.getTEmployeeInsurancePrePage(page, tEmployeeInsurancePre);
	}

	@Override
	public List<TEmployeeInsurancePre> getTEmployeeInsurancePreNoPage(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		//权限赋值
		tEmployeeInsurancePre.setType(CommonConstants.ONE_STRING);
		if (Common.isEmpty(tEmployeeInsurancePre.getStatusList())) {
			tEmployeeInsurancePre.setProcessStatus(CommonConstants.ZERO_STRING);
		}
		initSearchVo(tEmployeeInsurancePre);
		return baseMapper.getTEmployeeInsurancePreNoPage(tEmployeeInsurancePre);

	}

	@Override
	public long getTEmployeeInsuranceCount(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		tEmployeeInsurancePre.setStatusList(CommonConstants.processListPreArchivesStatus);
		initSearchVo(tEmployeeInsurancePre);
		return baseMapper.selectExportCount(tEmployeeInsurancePre);
	}

	/**
	 * 商险待办任务表批量导出
	 *
	 * @param searchVo 商险待办任务表
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TEmployeeInsurancePreSearchVo searchVo) {
		String fileName = "商险待办任务表批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<TEmployeeInsurancePreExportVo> list = new ArrayList<>();
		if (null == searchVo.getStatusList()) {
			searchVo.setStatusList(CommonConstants.processListPreArchivesStatus);
		}
		//权限赋值
		initSearchVo(searchVo);
		long count = baseMapper.selectExportCount(searchVo);
		try (ServletOutputStream out= response.getOutputStream();){
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, CommonConstants.UTF8));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TEmployeeInsurancePreExportVo.class).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.selectExportList(searchVo);
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcel.writerSheet("商险待办任务表" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("商险待办任务表" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		}
	}

	@Override
	public R confirm(List<String> idList) {
		List<TEmployeeInsurancePre> insurancePreList = baseMapper.selectList(Wrappers.<TEmployeeInsurancePre>query()
				.lambda().in(TEmployeeInsurancePre::getId, idList)
				.eq(TEmployeeInsurancePre::getProcessStatus, CommonConstants.ZERO_STRING));
		if (Common.isEmpty(insurancePreList)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		LambdaUpdateWrapper<TEmployeeInsurancePre> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(TEmployeeInsurancePre::getId,idList)
				.eq(TEmployeeInsurancePre::getProcessStatus, CommonConstants.ZERO_STRING)
				.set(TEmployeeInsurancePre::getProcessStatus, CommonConstants.ONE_STRING);
		this.update(updateWrapper);
		return R.ok();
	}

	@Override
	public R batchDispatcherInsurance(List<String> idList) {
		List<TEmployeeInsurancePre> insurancePreList = baseMapper.selectList(Wrappers.<TEmployeeInsurancePre>query()
				.lambda().in(TEmployeeInsurancePre::getId, idList)
				.in(TEmployeeInsurancePre::getProcessStatus, CommonConstants.processInsurancesStatus));
		if (Common.isEmpty(insurancePreList)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		List<String> pushIdList = insurancePreList.stream().map(TEmployeeInsurancePre::getId).collect(Collectors.toList());
		List<InsuranceAddParam> addParamList = new ArrayList<>();
		List<InsuranceBatchParam> batchAddParamList = new ArrayList<>();
		List<InsuranceReplaceParam> replaceAddParamList = new ArrayList<>();
		for (TEmployeeInsurancePre insurancePre : insurancePreList) {
			//新增、批增、替换
			if (CommonConstants.ONE_INT == insurancePre.getBuyType()) {
				InsuranceAddParam addParam = new InsuranceAddParam();
				addParam.setEmpName(insurancePre.getEmployeeName());
				addParam.setEmpIdcardNo(insurancePre.getEmpIdcard());
				addParam.setDeptNo(insurancePre.getDeptNo());
				addParam.setInsuranceCompanyName(insurancePre.getInsuranceCompanyName());
				addParam.setInsuranceTypeName(insurancePre.getInsuranceTypeName());
				addParam.setPolicyStart(DateUtil.dateToString(insurancePre.getPolicyStart(),DateUtil.ISO_EXPANDED_DATE_FORMAT));
				addParam.setPolicyEnd(DateUtil.dateToString(insurancePre.getPolicyEnd(),DateUtil.ISO_EXPANDED_DATE_FORMAT));
				addParam.setBuyStandard(insurancePre.getBuyStandard());
				addParam.setInsuranceProvinceName(insurancePre.getFileProvince());
				addParam.setInsuranceCityName(insurancePre.getFileCity());
				addParam.setSettleMonth(CommonConstants.EMPTY_STRING);
				addParam.setPost(insurancePre.getPosition());
				addParam.setRemark(CommonConstants.EMPTY_STRING);
				addParam.setInsurancePreId(insurancePre.getId());
				addParamList.add(addParam);
			}
			if (CommonConstants.THREE_INT == insurancePre.getBuyType()) {
				InsuranceBatchParam addParam = new InsuranceBatchParam();
				addParam.setEmpName(insurancePre.getEmployeeName());
				addParam.setEmpIdcardNo(insurancePre.getEmpIdcard());
				addParam.setDeptNo(insurancePre.getDeptNo());
				addParam.setInsuranceCompanyName(insurancePre.getInsuranceCompanyName());
				addParam.setInsuranceTypeName(insurancePre.getInsuranceTypeName());
				addParam.setPolicyNo(insurancePre.getPolicyNo());
				addParam.setBuyStandard(insurancePre.getBuyStandard());
				addParam.setInsuranceProvinceName(insurancePre.getFileProvince());
				addParam.setInsuranceCityName(insurancePre.getFileCity());
				addParam.setSettleMonth(CommonConstants.EMPTY_STRING);
				addParam.setPost(insurancePre.getPosition());
				addParam.setRemark(CommonConstants.EMPTY_STRING);
				addParam.setInsurancePreId(insurancePre.getId());
				batchAddParamList.add(addParam);
			}
			if (CommonConstants.FOUR_INT == insurancePre.getBuyType()) {
				InsuranceReplaceParam addParam = new InsuranceReplaceParam();
				addParam.setEmpName(insurancePre.getReplaceEmployeeName());
				addParam.setEmpIdcardNo(insurancePre.getReplaceEmpIdcard());
				addParam.setDeptNo(insurancePre.getReplaceDeptNo());
				addParam.setInsuranceCompanyName(insurancePre.getInsuranceCompanyName());
				addParam.setInsuranceTypeName(insurancePre.getInsuranceTypeName());
				addParam.setBuyStandard(insurancePre.getBuyStandard());
				addParam.setPolicyStart(DateUtil.dateToString(insurancePre.getPolicyStart(),DateUtil.ISO_EXPANDED_DATE_FORMAT));
				addParam.setPolicyEnd(DateUtil.dateToString(insurancePre.getPolicyEnd(),DateUtil.ISO_EXPANDED_DATE_FORMAT));
				addParam.setPost(insurancePre.getPosition());
				addParam.setReplaceEmpName(insurancePre.getEmployeeName());
				addParam.setReplaceDeptNo(insurancePre.getDeptNo());
				addParam.setReplaceEmpIdcardNo(insurancePre.getEmpIdcard());
				addParam.setRemark(CommonConstants.EMPTY_STRING);
				addParam.setInsurancePreId(insurancePre.getId());
				replaceAddParamList.add(addParam);
			}
		}
		//组装返回给前端
		List<InsuranceAddParam> paramList = new ArrayList<>();
		List<InsuranceBatchParam> batchParamList = new ArrayList<>();
		List<InsuranceReplaceParam> replaceParamList = new ArrayList<>();
		if (!addParamList.isEmpty()) {
			R<List<InsuranceAddParam>> listR = detailService.addInsurance(addParamList,null);
			if (Common.isNotNull(listR) && !listR.getData().isEmpty()) {
				paramList = listR.getData();
			}
		}
		if (!batchAddParamList.isEmpty()) {
			R<List<InsuranceBatchParam>> listR = detailService.batchInsurance(batchAddParamList,null);
			if (Common.isNotNull(listR) && !listR.getData().isEmpty()) {
				batchParamList = listR.getData();
			}
		}
		if (!replaceAddParamList.isEmpty()) {
			R<List<InsuranceReplaceParam>> listR = detailService.replaceInsurance(replaceAddParamList,null);
			if (Common.isNotNull(listR) && !listR.getData().isEmpty()) {
				replaceParamList = listR.getData();
			}
		}
		// 使用Stream合并三个列表
		List<InsuranceAutoParam> autoAddParamList = Stream.concat(
				paramList.stream().map(this::convertAddParam),
				Stream.concat(
						batchParamList.stream().map(this::convertBatchParam),
						replaceParamList.stream().map(this::convertReplaceParam)
				)
		).collect(Collectors.toList());

		if (autoAddParamList.isEmpty()) {
			LambdaUpdateWrapper<TEmployeeInsurancePre> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.in(TEmployeeInsurancePre::getId,pushIdList)
					.set(TEmployeeInsurancePre::getProcessStatus, CommonConstants.THREE_STRING);
			this.update(updateWrapper);
		} else {
			// 将 autoAddParamList 中的身份证和项目等信息提取出来，放入一个 Set 中
			Set<String> autoAddParamSet = autoAddParamList.stream()
					.map(param -> param.getEmpIdcardNo() + "-" + param.getDeptNo()
							+ "-" + param.getBuyStandard()+ "-" + param.getInsuranceTypeName()
							+ "-" + param.getInsuranceCompanyName() + "-" + param.getPolicyStart()
							+ "-" + param.getPolicyEnd())
					.collect(Collectors.toSet());

			// 找出 insurancePreList 中在 autoAddParamList 中存在的数据
			List<TEmployeeInsurancePre> existingList = insurancePreList.stream()
					.filter(pre -> autoAddParamSet.contains(pre.getEmpIdcard() + "-" + pre.getDeptNo()
							+ "-" + pre.getBuyStandard()+ "-" + pre.getInsuranceTypeName()
							+ "-" + pre.getInsuranceCompanyName() + "-" + DateUtil.dateToString(pre.getPolicyStart(),DateUtil.ISO_EXPANDED_DATE_FORMAT)
							+ "-" + DateUtil.dateToString(pre.getPolicyEnd(),DateUtil.ISO_EXPANDED_DATE_FORMAT)))
					.collect(Collectors.toList());

			// 找出 insurancePreList 中在 autoAddParamList 中不存在的数据
			List<TEmployeeInsurancePre> nonExistingList = insurancePreList.stream()
					.filter(pre -> !autoAddParamSet.contains(pre.getEmpIdcard() + "-" + pre.getDeptNo()
							+ "-" + pre.getBuyStandard()+ "-" + pre.getInsuranceTypeName()
							+ "-" + pre.getInsuranceCompanyName() + "-" + DateUtil.dateToString(pre.getPolicyStart(),DateUtil.ISO_EXPANDED_DATE_FORMAT)
							+ "-" + DateUtil.dateToString(pre.getPolicyEnd(),DateUtil.ISO_EXPANDED_DATE_FORMAT)))
					.collect(Collectors.toList());
			//派单成功的更新状态为代投保，派单失败更新成派单失败
			if (!existingList.isEmpty()){
				List<String> onIdList = existingList.stream().map(TEmployeeInsurancePre::getId).collect(Collectors.toList());
				LambdaUpdateWrapper<TEmployeeInsurancePre> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.in(TEmployeeInsurancePre::getId,onIdList)
						.set(TEmployeeInsurancePre::getProcessStatus, CommonConstants.TWO_STRING);
				this.update(updateWrapper);
			}
			if (!nonExistingList.isEmpty()){
				List<String> unIdList = nonExistingList.stream().map(TEmployeeInsurancePre::getId).collect(Collectors.toList());
				LambdaUpdateWrapper<TEmployeeInsurancePre> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.in(TEmployeeInsurancePre::getId,unIdList)
						.set(TEmployeeInsurancePre::getProcessStatus, CommonConstants.THREE_STRING);
				this.update(updateWrapper);
			}
		}
		return R.ok(autoAddParamList);
	}

	@Override
	@Transactional
	public Boolean saveInsurancePreInfo(EmployeeRegistrationPreVo registrationPreVo) {
		List<TEmployeeInsurancePreVo> employeeInsurancePreVos = registrationPreVo.getEmployeeInsurancePreVos();
		TEmployeeInsurancePre preExit;
		if (null != employeeInsurancePreVos && !employeeInsurancePreVos.isEmpty()) {
			for (TEmployeeInsurancePreVo preVo : employeeInsurancePreVos) {
				//判断是否存在商险待购买信息
				preExit = baseMapper.selectOne(Wrappers.<TEmployeeInsurancePre>query().lambda()
						.eq(TEmployeeInsurancePre::getRegisterId, preVo.getRegisterId())
						.eq(TEmployeeInsurancePre::getEmpIdcard, preVo.getEmpIdcard())
						.eq(TEmployeeInsurancePre::getBuyStandard, preVo.getBuyStandard())
						.eq(TEmployeeInsurancePre::getInsuranceTypeName, preVo.getInsuranceTypeName())
						.eq(TEmployeeInsurancePre::getInsuranceCompanyName, preVo.getInsuranceCompanyName())
						.eq(TEmployeeInsurancePre::getPolicyStart, preVo.getPolicyStart())
						.eq(TEmployeeInsurancePre::getPolicyEnd, preVo.getPolicyEnd())
						.last(CommonConstants.LAST_ONE_SQL));
				TEmployeeInsurancePre pre = new TEmployeeInsurancePre();
				BeanUtils.copyProperties(preVo, pre);
				if (Common.isNotNull(preVo.getExpectedCollectionTime())) {
					pre.setExpectedCollectionTime(LocalDateTimeUtils.dateToLocalDateTime(preVo.getExpectedCollectionTime()));
				}
				if (Common.isNotNull(preExit)) {
					pre.setId(preExit.getId());
					baseMapper.insert(pre);
					baseMapper.deleteById(preExit);
				} else {
					baseMapper.insert(pre);
					//暂时不需要，先注释，后续可能会需要
//					if (Common.isNotNull(pre.getExpectedCollectionTime())) {
//						// 事务提交后触发调度
//						TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
//							@Override
//							public void afterCommit() {
//								LocalDateTime now = LocalDateTime.now();
//								if (pre.getExpectedCollectionTime().isEqual(now)) {
//									scheduleService.executeTask(pre.getId());
//								} else if (preVo.getExpectedCollectionTime().compareTo(LocalDateTimeUtils.convertLDTToDate(now)) > 0){
//									scheduleService.scheduleTask(pre);
//								}
//							}
//						});
//					}
				}
			}
		}
		return true;
	}

	@Override
	public TEmployeeInsuranceSelectVo selectInsurancePreInfoList(TEmployeeInsurancePreVo preVo) {
		TEmployeeInsuranceSelectVo selectVo = new TEmployeeInsuranceSelectVo();
		List<TEmployeeInsurancePre> list = baseMapper.selectList(Wrappers.<TEmployeeInsurancePre>query().lambda()
				.eq(TEmployeeInsurancePre::getEmpIdcard, preVo.getEmpIdcard())
				.eq(TEmployeeInsurancePre::getBuyStandard, preVo.getBuyStandard())
				.eq(TEmployeeInsurancePre::getInsuranceTypeName, preVo.getInsuranceTypeName())
				.eq(TEmployeeInsurancePre::getInsuranceCompanyName, preVo.getInsuranceCompanyName())
				.eq(TEmployeeInsurancePre::getPolicyStart, preVo.getPolicyStart())
				.eq(TEmployeeInsurancePre::getPolicyEnd, preVo.getPolicyEnd())
		);
		selectVo.setInsurancePreList(list);
		return selectVo;
	}

	@Override
	public void updateInsurancePreCustomerName(EmployeeRegistrationCustomerUserUpdateVo updateVo) {
		LambdaUpdateWrapper<TEmployeeInsurancePre> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(TEmployeeInsurancePre::getDeptNo,updateVo.getDeptNo())
				.set(TEmployeeInsurancePre::getCustomerUsername, updateVo.getCustomerUserName())
				.set(TEmployeeInsurancePre::getCustomerUserLoginname, updateVo.getCustomerUserLoginName());
		this.update(updateWrapper);
	}

	@Override
	public void pushWxConfrimMessage() {
		//获取所有预计派单时间为当天而且状态是待确认的商险待购买数据
		List<TEmployeeInsurancePre> unConfirmList = baseMapper.getAllUnconfimData();
		if (Common.isNotNull(unConfirmList) && !unConfirmList.isEmpty()) {
			for (TEmployeeInsurancePre pre : unConfirmList) {
				try {
					sendMessageToWx(pre);
				} catch (Exception e) {
					log.error("执行异常", e);
				}
			}
		}
	}

	@Override
	public void pushDisConfrimInsurances() {
		//获取所有待派单的数据
		List<String> unConfirmList = baseMapper.getAllUnDisData();
		if (null != unConfirmList && !unConfirmList.isEmpty()) {
			try {
				this.batchDispatcherInsurance(unConfirmList);
			} catch (Exception e) {
				log.error("执行异常", e);
			}
		}
	}

	/**
	 * @Description: 获取前端客服的所有项目权限
	 * @Author: huych
	 * @Date: 2025/3/13 17:02
	 * @return:
	 **/
	public void initSearchVo(TEmployeeInsurancePreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		long roleId = 1839501715787390978L;
		boolean isSsc = this.haveRole(user, roleId);
		if (isSsc || CommonConstants.ZERO_STRING.equals(user.getSystemFlag())) {
			searchVo.setAuthSql(null);
			return;
		}
		if (Common.isNotNull(searchVo.getType()) && CommonConstants.ONE_STRING.equals(searchVo.getType())) {
			searchVo.setAuthSql(null);
			//获取项目信息
			R<TSettleDomainRegistListVo> domainR = archivesDaprUtil.getAllDeptByCustomerLoginName(user.getUsername());
			if (null != domainR && null != domainR.getData() && null != domainR.getData().getDeptNos() && !domainR.getData().getDeptNos().isEmpty()) {
				searchVo.setDeptNoList(domainR.getData().getDeptNos());
			} else {
				searchVo.setId(CommonConstants.ONE_STRING_NEGATE);
			}
		}
	}

	public boolean haveRole(YifuUser user, long roleId) {
		List<Long> roleList = user.getClientRoleMap().get(ClientNameConstants.CLIENT_MVP);
		for (Long role : roleList) {
			if (role == roleId) {
				return true;
			}
		}
		return false;
	}

	private InsuranceAutoParam convertAddParam(InsuranceAddParam addParam) {
		InsuranceAutoParam autoParam = new InsuranceAutoParam();
		// 复制InsuranceAddParam的字段
		autoParam.setEmpName(addParam.getEmpName());
		autoParam.setEmpIdcardNo(addParam.getEmpIdcardNo());
		autoParam.setDeptNo(addParam.getDeptNo());
		autoParam.setInsuranceCompanyName(addParam.getInsuranceCompanyName());
		autoParam.setInsuranceTypeName(addParam.getInsuranceTypeName());
		autoParam.setPolicyStart(addParam.getPolicyStart());
		autoParam.setPolicyEnd(addParam.getPolicyEnd());
		autoParam.setBuyStandard(addParam.getBuyStandard());
		autoParam.setInsuranceProvinceName(addParam.getInsuranceProvinceName());
		autoParam.setInsuranceCityName(addParam.getInsuranceCityName());
		autoParam.setSettleMonth(addParam.getSettleMonth());
		autoParam.setPost(addParam.getPost());
		autoParam.setRemark(addParam.getRemark());
		autoParam.setErrorMessage(addParam.getErrorMessage());
		return autoParam;
	}

	private InsuranceAutoParam convertBatchParam(InsuranceBatchParam batchParam) {
		InsuranceAutoParam autoParam = new InsuranceAutoParam();
		// 复制InsuranceBatchParam的字段
		autoParam.setEmpName(batchParam.getEmpName());
		autoParam.setEmpIdcardNo(batchParam.getEmpIdcardNo());
		autoParam.setDeptNo(batchParam.getDeptNo());
		autoParam.setInsuranceCompanyName(batchParam.getInsuranceCompanyName());
		autoParam.setInsuranceTypeName(batchParam.getInsuranceTypeName());
		autoParam.setPolicyNo(batchParam.getPolicyNo());
		autoParam.setBuyStandard(batchParam.getBuyStandard());
		autoParam.setInsuranceProvinceName(batchParam.getInsuranceProvinceName());
		autoParam.setInsuranceCityName(batchParam.getInsuranceCityName());
		autoParam.setSettleMonth(batchParam.getSettleMonth());
		autoParam.setPost(batchParam.getPost());
		autoParam.setRemark(batchParam.getRemark());
		autoParam.setErrorMessage(batchParam.getErrorMessage());
		return autoParam;
	}

	private InsuranceAutoParam convertReplaceParam(InsuranceReplaceParam replaceParam) {
		InsuranceAutoParam autoParam = new InsuranceAutoParam();
		// 复制InsuranceReplaceParam的字段
		autoParam.setEmpName(replaceParam.getEmpName());
		autoParam.setEmpIdcardNo(replaceParam.getEmpIdcardNo());
		autoParam.setDeptNo(replaceParam.getDeptNo());
		autoParam.setInsuranceCompanyName(replaceParam.getInsuranceCompanyName());
		autoParam.setInsuranceTypeName(replaceParam.getInsuranceTypeName());
		autoParam.setBuyStandard(replaceParam.getBuyStandard());
		autoParam.setPolicyEnd(replaceParam.getPolicyEnd());
		autoParam.setPolicyStart(replaceParam.getPolicyStart());
		autoParam.setPost(replaceParam.getPost());
		autoParam.setReplaceEmpName(replaceParam.getReplaceEmpName());
		autoParam.setReplaceDeptNo(replaceParam.getReplaceDeptNo());
		autoParam.setReplaceEmpIdcardNo(replaceParam.getReplaceEmpIdcardNo());
		autoParam.setErrorMessage(replaceParam.getErrorMessage());
		return autoParam;
	}

	//发送企业微信待办
	private void sendMessageToWx(TEmployeeInsurancePre insurancePre) {
		//获取前端客服
		SysUser user;
		if (Common.isEmpty(insurancePre.getCustomerUserLoginname())) {
			return;
		}
		R<SysUser> res = upmsDaprUtils.getSimpleUserByLoginName(insurancePre.getCustomerUserLoginname());
		if (Common.isNotNull(res) && Common.isNotNull(res.getData())) {
			user = res.getData();
		} else {
			return;
		}
		StringBuilder sendUser = null;
		if (Common.isNotKong(user.getWxMessage())) {
			sendUser = new StringBuilder(user.getWxMessage());
		}
		if (sendUser != null) {
			RestTemplate restTemplate = new RestTemplate();
			Map<String, Object> requestMap = new HashMap<>();
			Map<String, Object> textcard = new HashMap<>();
			String authUrl = String.format(SecurityConstants.WX_GET_MESSAGE_AUTH_URL, wxConfig.getCorpid(), wxConfig.getDomainName() + "/auth/oauth/wxLogin", "02" + insurancePre.getCustomerUserLoginname());
			StringBuilder description = new StringBuilder();
			String title = "商险投保确认";
			description.append("您有新的商险购买待确认数据，请及时确认").append("<br>");
			textcard.put("title", title);
			textcard.put("url", authUrl);
			textcard.put("description", description.toString());
			requestMap.put("touser", sendUser);
			requestMap.put("agentid", wxConfig.getAgentid());
			requestMap.put("msgtype", "textcard");
			requestMap.put("textcard", textcard);
			// 必须加上header说明
			if (!wxConfig.sendTextCard(restTemplate, requestMap)) {
				wxConfig.sendTextCard(restTemplate, requestMap);
			}
		}
	}
	/**
	 * @param empPreId 入职确认ID
	 * @Description: 根据
	 * @Author: hgw
	 * @Date: 2025/4/7 18:29
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre>
	 **/
	@Override
	public EmployeePreLogListVo getListByEmpPreId(String empPreId) {
		EmployeePreLogListVo vo = new EmployeePreLogListVo();
		List<TEmployeeInsurancePre> preList = baseMapper.getListByEmpPreId(empPreId);
		vo.setPreList(preList);
		return vo;
	}

	/**
	 * @Description: 先删后增
	 * @Author: hgw
	 * @Date: 2025/4/8 11:30
	 * @return: boolean
	 **/
	@Override
	public boolean saveOrUpdateInsuranceList(List<TEmployeeInsurancePre> preList) {
		baseMapper.deleteByEmpPreId(preList.get(0).getRegisterId());
		this.saveOrUpdateBatch(preList);
		return true;
	}

	/**
	 * @Description: 删除
	 * @Author: hgw
	 * @Date: 2025/4/10 14:49
	 * @return: boolean
	 **/
	@Override
	public boolean deleteInsuranceByPreId(String preId) {
		baseMapper.deleteByEmpPreId(preId);
		return true;
	}

}
