package com.yifu.cloud.plus.v1.yifu.social.config;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CustomCellWriteWidthTwoConfig extends AbstractColumnWidthStyleStrategy {


	@Override
	protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer integer, Boolean isHead) {
		boolean needSetWidth = isHead || !CollectionUtils.isEmpty(cellDataList);
		if (needSetWidth) {
			Sheet sheet = writeSheetHolder.getSheet();
			int columnIndex = cell.getColumnIndex();
			// 单元格文本长度大于45换行
			if (columnIndex == 3) {
				//要求将当前列的列宽设置为33英寸，理论值应该是33×256=8448，
				//但是这里的设值是8648，具体原因请看下面的计算逻辑
				sheet.setColumnWidth(0, 1000);
				sheet.setColumnWidth(1, 3000);
				sheet.setColumnWidth(3, 5000);
				sheet.setColumnWidth(5, 1000);
				sheet.setColumnWidth(6, 1000);
				sheet.setColumnWidth(7, 1000);
				sheet.setColumnWidth(8, 1000);
				sheet.setColumnWidth(9, 1000);
				sheet.setColumnWidth(10, 1000);
				sheet.setColumnWidth(11, 1000);
				sheet.setColumnWidth(12, 1500);
				sheet.setColumnWidth(13, 1500);
				sheet.setColumnWidth(14, 1500);
				sheet.setColumnWidth(15, 1500);
				sheet.setColumnWidth(16, 1500);
				sheet.setColumnWidth(17, 1500);
				sheet.setColumnWidth(18, 1000);
				sheet.setColumnWidth(19, 1000);
				sheet.setColumnWidth(20, 1500);
				sheet.setColumnWidth(21, 1500);
				sheet.setColumnWidth(22, 1000);
				sheet.setColumnWidth(23, 1000);
				sheet.setColumnWidth(24, 3500);
			}
		}
	}
}