/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentError;
import com.yifu.cloud.plus.v1.yifu.social.service.TAutoPaymentErrorService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentErrorSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 社保士兵实缴核验错误反馈表
 *
 * @author hgw
 * @date 2024-06-06 20:55:31
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautopaymenterror")
@Tag(name = "社保士兵实缴核验错误反馈表管理")
public class TAutoPaymentErrorController {

	private final TAutoPaymentErrorService tAutoPaymentErrorService;


	/**
	 * 简单分页查询
	 *
	 * @param page              分页对象
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TAutoPaymentError>> getTAutoPaymentErrorPage(Page<TAutoPaymentError> page, TAutoPaymentErrorSearchVo tAutoPaymentError) {
		return new R<>(tAutoPaymentErrorService.getTAutoPaymentErrorPage(page, tAutoPaymentError));
	}

	/**
	 * 不分页查询
	 *
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('social_tautopaymenterror_get')" )
	public R<List<TAutoPaymentError>> getTAutoPaymentErrorNoPage(@RequestBody TAutoPaymentErrorSearchVo tAutoPaymentError) {
		return R.ok(tAutoPaymentErrorService.noPageDiy(tAutoPaymentError));
	}

	/**
	 * 通过id查询社保士兵实缴核验错误反馈表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_tautopaymenterror_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_tautopaymenterror_get')")
	public R<TAutoPaymentError> getById(@PathVariable("id") String id) {
		return R.ok(tAutoPaymentErrorService.getById(id));
	}

	/**
	 * 新增社保士兵实缴核验错误反馈表
	 *
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return R
	 */
	@Operation(summary = "新增社保士兵实缴核验错误反馈表", description = "新增社保士兵实缴核验错误反馈表：hasPermission('social_tautopaymenterror_add')")
	@SysLog("新增社保士兵实缴核验错误反馈表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('social_tautopaymenterror_add')")
	public R<Boolean> save(@RequestBody TAutoPaymentError tAutoPaymentError) {
		return R.ok(tAutoPaymentErrorService.save(tAutoPaymentError));
	}

	/**
	 * 修改社保士兵实缴核验错误反馈表
	 *
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return R
	 */
	@Operation(summary = "修改社保士兵实缴核验错误反馈表", description = "修改社保士兵实缴核验错误反馈表：hasPermission('social_tautopaymenterror_edit')")
	@SysLog("修改社保士兵实缴核验错误反馈表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('social_tautopaymenterror_edit')")
	public R<Boolean> updateById(@RequestBody TAutoPaymentError tAutoPaymentError) {
		return R.ok(tAutoPaymentErrorService.updateById(tAutoPaymentError));
	}

	/**
	 * 通过id删除社保士兵实缴核验错误反馈表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除社保士兵实缴核验错误反馈表", description = "通过id删除社保士兵实缴核验错误反馈表：hasPermission('social_tautopaymenterror_del')")
	@SysLog("通过id删除社保士兵实缴核验错误反馈表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_tautopaymenterror_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tAutoPaymentErrorService.removeById(id));
	}

	/**
	 * 社保士兵实缴核验错误反馈表 批量导出
	 *
	 * @author hgw
	 * @date 2024-06-06 20:55:31
	 **/
	@Operation(description = "导出社保士兵实缴核验错误反馈表 hasPermission('social_tautopaymenterror-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('social_tautopaymenterror-export')")
	public void export(HttpServletResponse response, @RequestBody TAutoPaymentErrorSearchVo searchVo) {
		if (Common.isNotNull(searchVo.getParentId())) {
			tAutoPaymentErrorService.listExport(response, searchVo);
		}
	}

}
