/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * EKP发票池发票信息表
 *
 * @author fxj
 * @date 2025-07-21 09:49:56
 */
@Data
@TableName("view_invoice_info")
@Schema(description = "EKP发票池发票信息表")
public class EkpInvoiceInfo {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 预警科目ID
	 */
	@ExcelAttribute(name = "预警科目ID", maxLength = 1000)
	@Length(max = 1000, message = "预警科目ID不能超过1000个字符")
	@ExcelProperty("预警科目ID")
	@Schema(description = "预警科目ID")
	private String fdAlertSubject;
	/**
	 * 预警科目
	 */
	@ExcelAttribute(name = "预警科目", maxLength = 1000)
	@Length(max = 1000, message = "预警科目不能超过1000个字符")
	@ExcelProperty("预警科目")
	@Schema(description = "预警科目")
	private String fdAlertSubjectText;
	/**
	 * 有效日期始
	 */
	@ExcelAttribute(name = "有效日期始", isDate = true)
	@ExcelProperty("有效日期始")
	@Schema(description = "有效日期始")
	private Date fdEffectiveStartDate;
	/**
	 * 	有效日期止
	 */
	@ExcelAttribute(name = "有效日期止", isDate = true)
	@ExcelProperty("有效日期止")
	@Schema(description = "有效日期止")
	private Date fdEffectiveEndDate;
	/**
	 * 检测方式
	 */
	@ExcelAttribute(name = "检测方式", maxLength = 200)
	@Length(max = 200, message = "检测方式不能超过200个字符")
	@ExcelProperty("检测方式")
	@Schema(description = "检测方式")
	private String fdDetectionMethod;
	/**
	 * 阈值（%）
	 */
	@ExcelAttribute(name = "阈值")
	@ExcelProperty("阈值")
	@Schema(description = "阈值")
	private Integer fdThresholdValue;
	/**
	 * 是否有效：是 否
	 */
	@ExcelAttribute(name = "是否有效", maxLength = 200)
	@Length(max = 200, message = "是否有效不能超过200个字符")
	@ExcelProperty("是否有效")
	@Schema(description = "是否有效")
	private String fdIsActive;
	/**
	 * 预警内容
	 */
	@ExcelAttribute(name = "预警内容")
	@ExcelProperty("预警内容")
	@Schema(description = "预警内容")
	private String fdAlertMessage;
	/**
	 * 检测方式-每日时间
	 */
	@ExcelAttribute(name = "检测方式-每日", isDate = true)
	@ExcelProperty("检测方式-每日")
	@Schema(description = "检测方式-每日")
	private Date fdEverydayTime;
	/**
	 * 检测方式-每月：每月时间（日）
	 */
	@ExcelAttribute(name = "检测方式", maxLength = 20)
	@Length(max = 20, message = "检测方式不能超过20个字符")
	@ExcelProperty("检测方式")
	@Schema(description = "检测方式")
	private String fdChecktype;
	/**
	 * 检测方式-每月：1.每月 2.每日
	 */
	@ExcelAttribute(name = "检测方式-每月")
	@ExcelProperty("检测方式-每月")
	@Schema(description = "检测方式-每月")
	private Integer fdMonthday;

}
