/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 招行卡
 *
 * @author hgw
 * @date 2025-09-09 16:22:40
 */
@Data
@TableName("ekp_zhao_hang_detail")
@Schema(description = "招行卡")
public class EkpZhaoHangDetail {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	@Schema(description = "流水号")
	private String fdNo;
	@Schema(description = "交易时间")
	private String fdDate;
	@Schema(description = "交易金额")
	private BigDecimal fdMoney;
	@Schema(description = "交易商户名称")
	private String fdAcpName;
	@Schema(description = "交易卡号")
	private String fdBankNo;
	// 作为EKP登录用户查询的ID（用登录ID，查找ekp_zhao_hang_bank_no里的fdAccountId，再关联本表查询数据）
	@Schema(description = "账户ID")
	private String fdAccountId;
	@Schema(description = "中文名")
	private String fdEmpName;
	@Schema(description = "EKP的登录用户的FdId")
	private String fdUserId;
	@Schema(description = "创建时间")
	private LocalDateTime createTime;

}
