/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 自动化日志
 *
 * @author hgw
 * @date 2024-08-30 10:27:16
 */
@Data
// 设置所有列宽 hgw 2024-9-3 14:14:49
@ColumnWidth(20)
public class TSocialSoldierLogExportVo implements Serializable {

	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelProperty("日期")
	private LocalDateTime createTime;

	@ExcelProperty("派单项")
	private String dispatchItem;

	@ExcelProperty("社保户")
	private String socialHuName;

	@ExcelProperty("类型")
	private String type;

	@ExcelProperty("结果")
	private String remark;

}
