/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchDayConf;
import com.yifu.cloud.plus.v1.yifu.social.service.TDispatchDayConfService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchDayConfSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 各个地市派单日期
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tdispatchdayconf" )
@Tag(name = "各个地市派单日期管理")
public class TDispatchDayConfController {

    private final TDispatchDayConfService tDispatchDayConfService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tDispatchDayConf 各个地市派单日期
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TDispatchDayConf>> getTDispatchDayConfPage(Page<TDispatchDayConf> page, TDispatchDayConf tDispatchDayConf) {
        return  new R<>(tDispatchDayConfService.getTDispatchDayConfPage(page,tDispatchDayConf));
    }
    /**
     * 不分页查询
     * @param tDispatchDayConf 各个地市派单日期
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf_get')" )
    public R<List<TDispatchDayConf>> getTDispatchDayConfNoPage(@RequestBody TDispatchDayConf tDispatchDayConf) {
        return R.ok(tDispatchDayConfService.list(Wrappers.query(tDispatchDayConf)));
    }

    /**
     * 通过id查询各个地市派单日期
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tdispatchdayconf_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf_get')" )
    public R<TDispatchDayConf> getById(@PathVariable("id" ) String id) {
        return R.ok(tDispatchDayConfService.getById(id));
    }

    /**
     * 新增各个地市派单日期
     * @param tDispatchDayConf 各个地市派单日期
     * @return R
     */
    @Operation(summary = "新增各个地市派单日期", description = "新增各个地市派单日期：hasPermission('demo_tdispatchdayconf_add')")
    @SysLog("新增各个地市派单日期" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf_add')" )
    public R<Boolean> save(@RequestBody TDispatchDayConf tDispatchDayConf) {
        return R.ok(tDispatchDayConfService.save(tDispatchDayConf));
    }

    /**
     * 修改各个地市派单日期
     * @param tDispatchDayConf 各个地市派单日期
     * @return R
     */
    @Operation(summary = "修改各个地市派单日期", description = "修改各个地市派单日期：hasPermission('demo_tdispatchdayconf_edit')")
    @SysLog("修改各个地市派单日期" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf_edit')" )
    public R<Boolean> updateById(@RequestBody TDispatchDayConf tDispatchDayConf) {
        return R.ok(tDispatchDayConfService.updateById(tDispatchDayConf));
    }

    /**
     * 通过id删除各个地市派单日期
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除各个地市派单日期", description = "通过id删除各个地市派单日期：hasPermission('demo_tdispatchdayconf_del')")
    @SysLog("通过id删除各个地市派单日期" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tDispatchDayConfService.removeById(id));
    }

    /**
	 * 各个地市派单日期 批量导入
	 *
     * @author fxj
     * @date 2022-07-15 11:38:05
	 **/
    @SneakyThrows
    @Operation(description = "批量新增各个地市派单日期 hasPermission('demo_tdispatchdayconf-batch-import')")
    @SysLog("批量新增各个地市派单日期")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tDispatchDayConfService.importDiy(file.getInputStream());
    }

    /**
     * 各个地市派单日期 批量导出
     * @author fxj
     * @date 2022-07-15 11:38:05
     **/
    @Operation(description = "导出各个地市派单日期 hasPermission('demo_tdispatchdayconf-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tdispatchdayconf-export')")
    public void export(HttpServletResponse response, @RequestBody TDispatchDayConfSearchVo searchVo) {
            tDispatchDayConfService.listExport(response,searchVo);
    }
}
