package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 含风险项目不购买申请表
 *
 * @author huych
 * @date 2025-01-10 11:24:38
 */
@Data
@ColumnWidth(25)
public class TInsuranceUnpurchaseApplyVo implements Serializable {

	/**
	 * 申请编号
	 */
	@ExcelAttribute(name = "申请编号")
	@Schema(description = "申请编号")
	@ExcelProperty("申请编号")
	private String applyNo;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	/**
	 * 创建者-姓名
	 */
	@ExcelAttribute(name = "申请人")
	@Schema(description = "申请人")
	@ExcelProperty("申请人")
	private String createName;

	/**
	 * 申请人所在部门名称
	 */
	@ExcelAttribute(name = "所属部门")
	@Schema(description = "所属部门")
	@ExcelProperty("所属部门")
	private String createUserDeptName;

	/**
	 * 申请时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@ExcelAttribute(name = "申请时间")
	@Schema(description = "申请时间")
	@ExcelProperty("申请时间")
	private LocalDateTime createTime;

	@ExcelAttribute(name = "当前处理人")
	@Schema(description = "当前处理人")
	@ExcelProperty("当前处理人")
	private String auditUser;

	/**
	 * 不购买原因 1 已购买社保 2 人员已离职
	 */
	@ExcelAttribute(name = "不购买原因")
	@Schema(description = "不购买原因")
	@ExcelProperty("不购买原因")
	private String reasonType;

	/**
	 * 申请状态 0 草稿 1待提交 2 待审核 3 审核通过 4 审核不通过
	 */
	@ExcelAttribute(name = "审批状态")
	@Schema(description = "审批状态")
	@ExcelProperty("审批状态")
	private String status;

}
