/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TPauseSalary;
import com.yifu.cloud.plus.v1.yifu.salary.service.TPauseSalaryService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPauseSalarySearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 暂停发表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpausesalary")
@Tag(name = "暂停发表管理")
public class TPauseSalaryController {

	private final TPauseSalaryService tPauseSalaryService;


	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param tPauseSalary 暂停发表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TPauseSalary>> getTPauseSalaryPage(Page<TPauseSalary> page, TPauseSalarySearchVo tPauseSalary) {
		return new R<>(tPauseSalaryService.getTPauseSalaryPage(page, tPauseSalary));
	}
}
