/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import java.io.Serializable;

/**
 * 社保士兵审核结果反馈文件解析
 *
 * @author hgw
 * @date 2024-5-27 11:14:07
 */
@Data
public class TSocialSoldierReturnAuditErrorVo extends RowIndex implements Serializable {

	@ExcelProperty("错误信息")
	private String errorInfo;

	@ExcelProperty("企业名称")
	private String companyName;
	@ExcelProperty("证件号码")
	private String idCard;
	@ExcelProperty("姓名")
	private String empName;

	@ExcelProperty("审核状态")
	private String auditStatus;
	// 医保有值，社保没值
	@ExcelProperty("审核意见")
	private String ysdRemark;
	// 社保独有的列
	@ExcelProperty("操作")
	private String ygsOperation;
}
