/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 法大大员工合同模板
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_contract_template")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大员工合同模板")
public class FddContractTemplate extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 合同类型的字典
     */
    @Schema(description ="合同类型的字典")
    private String type;

    /**
     * 合同编辑状态 1成功
     */
    @Schema(description ="合同编辑状态 1成功")
    private String modifyUploadStatus;

    /**
     * 省
     */
    @Schema(description ="省")
    private Integer province;

    /**
     * 市
     */
    @Schema(description ="市")
    private Integer city;

    /**
     * 是否有加班工资 0无加班工资 1有加班工资
     */
    @Schema(description ="是否有加班工资 0无加班工资 1有加班工资")
    private String overtimeWageFlag;

    /**
     * 法大大模板id
     */
    @Schema(description ="法大大模板id")
    private String fddTemplateId;

    /**
     * 本地模板名称
     */
    @Schema(description ="本地模板名称")
    private String localName;

    /**
     * 签署组织名称
     */
    @Schema(description ="签署组织名称")
    private String signerName;


}
