package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/8/17
 * @Description  有工资无社保导出对象
 * @Version 1.0
 */
@Data
public class THaveSalaryNoSocialExportVo implements Serializable {

	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50,needExport=true)
	@Schema(description = "客户名称", name = "customerName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "客户名称")
	private String customerName;
	/**
	 * 结算主体名称
	 */
	@NotBlank(message = "结算主体名称不能为空")
	@Length(max = 50, message = "结算主体名称不能超过50个字符")
	@ExcelAttribute(name = "结算主体名称", isNotEmpty = true, errorInfo = "结算主体名称不能为空", maxLength = 50,needExport=true)
	@Schema(description = "结算主体名称", name = "settlementOrganName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目名称")
	private String settlementOrganName;
	/**
	 * 员工名称
	 */
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32,needExport=true)
	@Schema(description = "员工姓名", name = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 32,needExport=true)
	@Schema(description = "身份证号", name = "employeeIdCard")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	private String employeeIdCard;

	/**
	 * 工资月份
	 */
	@NotBlank(message = "工资月份不能为空")
	@ExcelAttribute(name = "工资月份", isNotEmpty = true, errorInfo = "工资月份不能为空",needExport=true)
	@Schema(description = "工资月份", name = "month")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工资月份")
	private String month;

	/**
	 * 应发工资
	 */
	@Schema(description = "应发工资", name = "relaySalary")
	@ExcelAttribute(name = "应发工资", isNotEmpty = true, errorInfo = "应发工资不能为空", needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "应发工资")
	private String relaySalary;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;
	/**
	 * 反馈原因
	 */
	@Schema(description = "反馈原因", name = "reasonType")
	@ExcelAttribute(name = "反馈原因",  maxLength = 32, needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "反馈原因")
	private String feedBack;

}
