/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TForecastLibrary;
import com.yifu.cloud.plus.v1.yifu.social.vo.TForecastLibraryExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 预估费用
 *
 * @author hgw
 * @date 2022-07-18 16:21:40
 */
@Mapper
public interface TForecastLibraryMapper extends BaseMapper<TForecastLibrary> {
	/**
	 * 预估费用简单分页查询
	 *
	 * @param tForecastLibrary 预估费用
	 * @return
	 */
	IPage<TForecastLibrary> getTForecastLibraryPage(Page<TForecastLibrary> page, @Param("tForecastLibrary") TForecastLibrary tForecastLibrary);

	/**
	 * @Description: 导出
	 * @Author: hgw
	 * @Date: 2022/7/28 14:52
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.TForecastLibraryVo>
	 **/
	List<TForecastLibraryExportVo> exportLibrary(@Param("tForecastLibrary") TForecastLibrary tForecastLibrary);

	List<TPaymentBySalaryVo> selectTForecastBySalaryVo(@Param("tPaymentInfo") TPaymentBySalaryVo tPaymentInfo);

	/**
	 * 更新社保结算状态
	 * @Author hgw
	 * @Date 2020-4-13 16:01:59
	 * @param idList
	 * @param status
	 * @return
	 **/
	int updateForecastSocialStatusByIdList(@Param("idList") List<String> idList, @Param("status") String status);

	int updateForecastFundStatusByIdList(@Param("idList")List<String> idList, @Param("status") String status);

	int deleteForecastSocial(@Param("idCard") String idCard, @Param("socialPayMonth") String socialPayMonth, @Param("socialCreateMonth") String socialCreateMonth
			, @Param("fundPayMonth") String fundPayMonth, @Param("fundCreateMonth") String fundCreateMonth);

	void updateForSocialAndFound(@Param("infoVo") UpdateSocialFoundVo infoVo);

	/**
	 * 更新社保结算状态
	 * @Author huyc
	 * @Date 2022-8-30
	 * @param idList
	 * @return
	 **/
	int updatePushStatus(@Param("idList") List<String> idList);

	List<String> checkForecastChange(@Param("idSet") Set<String> idSet);

	/**
	 * @param idSet
	 * @Description: 修改缴费库
	 * @Author: hgw
	 * @Date: 2022-11-16 17:51:41
	 * @return: int
	 **/
	int changeForecastDept(@Param("idSet") Set<String> idSet, @Param("dept") TSettleDomainSelectVo dept);

	int updateForecastById(@Param("tForecastLibrary") TForecastLibrary tForecastLibrary);

	int updateForecastStatusById(@Param("tForecastLibrary") TForecastLibrary tForecastLibrary);

	List<TForecastLibrary> selectTForecastSocialInfoList();

	List<TForecastLibrary> selectTForecastFundInfoList();

}
