/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.order.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.entity.TOrderFileSyncLog;
import com.yifu.cloud.plus.v1.yifu.order.vo.TOrderFileSyncLogSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 项目订单附件同步日志信息
 *
 * @author fxj
 * @date 2024-11-15 17:21:46
 */
public interface TOrderFileSyncLogService extends IService<TOrderFileSyncLog> {
	/**
	 * 项目订单附件同步日志信息简单分页查询
	 *
	 * @param tOrderFileSyncLog 项目订单附件同步日志信息
	 * @return
	 */
	IPage<TOrderFileSyncLog> getTOrderFileSyncLogPage(Page<TOrderFileSyncLog> page, TOrderFileSyncLogSearchVo tOrderFileSyncLog);

	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	void listExport(HttpServletResponse response, TOrderFileSyncLogSearchVo searchVo);

	List<TOrderFileSyncLog> noPageDiy(TOrderFileSyncLogSearchVo searchVo);

    void saveAsso(String orderNo, String fileIds);

}
