/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 本期稿酬申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_statistics_remuneration")
@Schema(description = "本期稿酬申报表")
public class TStatisticsRemuneration {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelIgnore
	private String id;
	/**
	 * 申报单位
	 */
	@ExcelAttribute(name = "申报单位", maxLength = 32)
	@Length(max = 32, message = "申报单位不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String declareUnit;
	/**
	 * 申报月份（YYYYMM）
	 */
	@ExcelAttribute(name = "申报月份", isNotEmpty = true, errorInfo = "申报月份不能为空", maxLength = 6)
	@NotBlank(message = "申报月份（YYYYMM）不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 32)
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证件号码")
	private String empIdcard;
	/**
	 * 证件类型
	 */
	@ExcelAttribute(name = "证件类型", maxLength = 10)
	@Length(max = 10, message = "证件类型不能超过10个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证件类型")
	private String cardType;
	/**
	 * 收入
	 */
	@ExcelAttribute(name = "收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入")
	private BigDecimal income;
	/**
	 * 个税
	 */
	@ExcelAttribute(name = "个税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税")
	private BigDecimal personalTax;

}
