/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsCurrentReport;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsCurrentReportService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsCurrentReportSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 统计-本期申报
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tstatisticscurrentreport")
@Tag(name = "统计-本期申报管理")
public class TStatisticsCurrentReportController {

	private final TStatisticsCurrentReportService tStatisticsCurrentReportService;


	/**
	 * 简单分页查询
	 *
	 * @param page                     分页对象
	 * @param tStatisticsCurrentReport 统计-本期申报
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TStatisticsCurrentReport>> getTStatisticsCurrentReportPage(Page<TStatisticsCurrentReport> page, TStatisticsCurrentReportSearchVo tStatisticsCurrentReport) {
		return new R<>(tStatisticsCurrentReportService.getTStatisticsCurrentReportPage(page, tStatisticsCurrentReport));
	}

	/**
	 * 通过id查询统计-本期申报
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('salary_tstatisticscurrentreport_get')")
	@GetMapping("/{id}")
	public R<TStatisticsCurrentReport> getById(@PathVariable("id") String id) {
		return R.ok(tStatisticsCurrentReportService.getById(id));
	}

	/**
	 * 统计-本期申报 批量导出
	 *
	 * @author hgw
	 * @date 2022-08-05 11:40:14
	 **/
	@Operation(description = "导出统计-本期申报 hasPermission('salary_tstatisticscurrentreport-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('salary_tstatisticscurrentreport-export')")
	public void export(HttpServletResponse response, @RequestBody TStatisticsCurrentReportSearchVo tStatisticsCurrentReport) {
		if (Common.isEmpty(tStatisticsCurrentReport.getDeclareMonth())) {
			String nowMonth =  DateUtil.addMonth(0);  //本月
			tStatisticsCurrentReport.setDeclareMonth(nowMonth);
		}
		tStatisticsCurrentReportService.listExport(response, tStatisticsCurrentReport);
	}

	/**
	 * 通过id删除统计-工资薪金
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除统计-本期申报", description = "通过id删除统计-本期申报：hasPermission('salary_tstatisticscurrentreport_del')")
	@SysLog("通过id删除统计-本期申报")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('salary_tstatisticscurrentreport_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tStatisticsCurrentReportService.removeById(id));
	}

}
