/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialSoldierShenBaoTask;

import java.util.List;

/**
 * 社保自动化审核提交后的审核结果查询记录表
 *
 * @author hgw
 * @date 2024-05-23 17:40:37
 */
public interface TSocialSoldierShenBaoTaskService extends IService<TSocialSoldierShenBaoTask> {
	/**
	 * 社保自动化审核提交后的审核结果查询记录表简单分页查询
	 *
	 * @param tSocialSoldierShenBaoTask 社保自动化审核提交后的审核结果查询记录表
	 * @return
	 */
	List<TSocialSoldierShenBaoTask> getTSocialSoldierShenBaoTaskList(TSocialSoldierShenBaoTask tSocialSoldierShenBaoTask);
	/**
	 * @param
	 * @Description: 获取复核记录为未复核的情况
	 * @Author: hgw
	 * @Date: 2024/6/7 11:56
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.TSocialSoldierShenBaoTask>
	 **/
	List<TSocialSoldierShenBaoTask> getTSocialSoldierTaskListByRe();

	/**
	 * @param type
	 * @Description: 获取实缴3张表推送后的任务ID，以用来拉取数据
	 * @Author: hgw
	 * @Date: 2024/5/31 18:13
	 * @return: java.lang.String
	 **/
	TSocialSoldierShenBaoTask getSoldierTaskAddIdByType(String type);

	/**
	 * @Description: 删除实缴推送
	 * @Author: hgw
	 * @Date: 2024/6/6 21:49
	 * @return: void
	 **/
	void deleteByPayment();

	/**
	 * @Description: 删除实缴再次推送
	 * @Author: hgw
	 * @Date: 2024/6/6 21:50
	 * @return: void
	 **/
	void deleteByRePayment();

}
