/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 商险定时失败的企微的详情
 *
 * @author hgw
 * @date 2025-08-07 17:49:14
 */
@Data
@TableName("t_employee_insurance_pre_qw_detail")
@Schema(description = "商险定时失败的企微的详情")
public class TEmployeeInsurancePreQwDetail {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 关联主键（t_employee_insurance_pre_qw表的ID）
	 */
	@ExcelAttribute(name = "关联主键（t_employee_insurance_pre_qw表的ID）", isNotEmpty = true, errorInfo = "关联主键（t_employee_insurance_pre_qw表的ID）不能为空", maxLength = 36)
	@NotBlank(message = "关联主键（t_employee_insurance_pre_qw表的ID）不能为空")
	@Length(max = 36, message = "关联主键（t_employee_insurance_pre_qw表的ID）不能超过36个字符")
	@ExcelProperty("关联主键（t_employee_insurance_pre_qw表的ID）")
	@Schema(description = "关联主键（t_employee_insurance_pre_qw表的ID）")
	private String mainId;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 30)
	@Length(max = 30, message = "姓名不能超过30个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 身份证
	 */
	@ExcelAttribute(name = "身份证", maxLength = 18)
	@Length(max = 18, message = "身份证不能超过18个字符")
	@ExcelProperty("身份证")
	@Schema(description = "身份证")
	private String empIdcard;
	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因", maxLength = 200)
	@Length(max = 200, message = "失败原因不能超过200个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String errorInfo;
	/**
	 * 失败时间
	 */
	@ExcelAttribute(name = "失败时间", isDate = true)
	@ExcelProperty("失败时间")
	@Schema(description = "失败时间")
	private LocalDateTime errorTime;
	/**
	 * 商险待派单ID（t_employee_insurance_pre的ID）
	 */
	@ExcelAttribute(name = "商险待派单ID（t_employee_insurance_pre的ID）", maxLength = 36)
	@Length(max = 36, message = "商险待派单ID（t_employee_insurance_pre的ID）不能超过36个字符")
	@ExcelProperty("商险待派单ID（t_employee_insurance_pre的ID）")
	@Schema(description = "商险待派单ID（t_employee_insurance_pre的ID）")
	private String preId;

}
