package com.yifu.cloud.plus.v1.permission.mapper;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserRoleRes;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 新权限-账号-角色关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Mapper
public interface SysUserRoleResMapper extends BaseMapper<SysUserRoleRes> {
	/**
	 * 新权限-账号-角色关联表简单分页查询
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return
	 */
	IPage<SysUserRoleRes> getSysUserRoleResPage(Page<SysUserRoleRes> page, @Param("sysUserRoleRes") SysUserRoleRes sysUserRoleRes);

	/**
	 * @param roleId
	 * @Description: 根据角色id获取被使用的账号名称
	 * @Author: hgw
	 * @Date: 2023/9/8 17:38
	 * @return: java.util.List<java.lang.String>
	 **/
	List<String> getSysUserByRoleId(@Param("roleId") String roleId);

	boolean deleteByUserId(@Param("loginName") String loginName);

	boolean deleteByRoleId(@Param("roleId") String roleId);
}
