/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.MSalaryPaymentRes;
import com.yifu.cloud.plus.v1.yifu.salary.vo.MSalaryPaymentResSearchVo;

/**
 * 工资缴费库-同步表（同步完成后真删除数据）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface MSalaryPaymentResService extends IService<MSalaryPaymentRes> {
	/**
	 * 工资缴费库-同步表（同步完成后真删除数据）简单分页查询
	 *
	 * @param mSalaryPaymentRes 工资缴费库-同步表（同步完成后真删除数据）
	 * @return
	 */
	IPage<MSalaryPaymentRes> getMSalaryPaymentResPage(Page<MSalaryPaymentRes> page, MSalaryPaymentResSearchVo mSalaryPaymentRes);

}
