/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 预估临时政策配置表
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@Data
@TableName("t_agent_config")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预估临时政策配置表")
public class TAgentConfig extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "主键" )
    @Schema(description ="主键")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
    private String id;

    /**
     * 是否启用(0启用/1禁用)
     */
    @ExcelAttribute(name = "是否启用(0启用/1禁用)" )
    @Schema(description ="是否启用(0启用/1禁用)")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否启用(0启用/1禁用)")
    private Integer openFlag;

    /**
     * 适用对象（0单位/1个人/2全部）
     */
    @ExcelAttribute(name = "适用对象（0单位/1个人/2全部）" )
    @Schema(description ="适用对象（0单位/1个人/2全部）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用对象（0单位/1个人/2全部）")
    private Integer target;

    /**
     * 适用省份
     */
    @ExcelAttribute(name = "适用省份" )
    @Schema(description ="适用省份")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用省份")
    private String province;

    /**
     * 适用地市
     */
    @ExcelAttribute(name = "适用地市" )
    @Schema(description ="适用地市")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用地市")
    private String city;

    /**
     * 医疗收取（0全额/1减半/2不收取）
     */
    @ExcelAttribute(name = "医疗收取（0全额/1减半/2不收取）" )
    @Schema(description ="医疗收取（0全额/1减半/2不收取）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗收取（0全额/1减半/2不收取）")
    private String medical;

    /**
     * 工伤收取（0全额/1减半/2不收取）
     */
    @ExcelAttribute(name = "工伤收取（0全额/1减半/2不收取）" )
    @Schema(description ="工伤收取（0全额/1减半/2不收取）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤收取（0全额/1减半/2不收取）")
    private String injury;

    /**
     * 生育收取（0全额/1减半/2不收取）
     */
    @ExcelAttribute(name = "生育收取（0全额/1减半/2不收取）" )
    @Schema(description ="生育收取（0全额/1减半/2不收取）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育收取（0全额/1减半/2不收取）")
    private String bear;

    /**
     * 养老收取（0全额/1减半/2不收取）
     */
    @ExcelAttribute(name = "养老收取（0全额/1减半/2不收取）" )
    @Schema(description ="养老收取（0全额/1减半/2不收取）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老收取（0全额/1减半/2不收取）")
    private String pension;

    /**
     * 失业收取（0全额/1减半/2不收取）
     */
    @ExcelAttribute(name = "失业收取（0全额/1减半/2不收取）" )
    @Schema(description ="失业收取（0全额/1减半/2不收取）")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业收取（0全额/1减半/2不收取）")
    private String unemployed;

    /**
     * 适用年
     */
    @ExcelAttribute(name = "适用年" )
    @Schema(description ="适用年")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用年")
    private String year;

    /**
     * 生效起月份 包含
     */
    @ExcelAttribute(name = "生效起月份 包含" )
    @Schema(description ="生效起月份 包含")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生效起月份 包含")
    private String startMonth;

    /**
     * 生效止月份 包含
     */
    @ExcelAttribute(name = "生效止月份 包含" )
    @Schema(description ="生效止月份 包含")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生效止月份 包含")
    private String endMonth;


}
