/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import java.io.Serializable;
import java.util.Date;

/**
 * 员工学历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@Schema(description = "员工学历信息表")
public class TEmpEducationExportVo  implements Serializable {

	/**
	 * 主键
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	@ExcelProperty("唯一标识")
	private String id;

	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 20)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 20)
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 学校名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 50)
	@Schema(description = "学校名称")
	@ExcelProperty("学校")
	private String school;

	/**
	 * 院系名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 50)
	@Schema(description = "院系名称")
	@ExcelProperty("院系名称")
	private String collageSystem;

	/**
	 * 专业
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 50)
	@Schema(description = "专业")
	@ExcelProperty("专业")
	private String major;

	/**
	 * 学历名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 50)
	@Schema(description = "学历名称")
	@ExcelAttribute(name = "学历", isNotEmpty = false,errorInfo = "学历不可为空", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION)
	@ExcelProperty("学历")
	private String educationName;

	/**
	 * 学历类型：全日制、自考、函授等
	 */
	@ExcelAttribute(name = "学历类型", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION_TYPE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "学历类型：全日制、自考、函授等")
	@ExcelProperty("学历类型")
	private String type;

	/**
	 * 最高学历标识0是/1否
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "最高学历标识0是/1否")
	@ExcelProperty("最高学历")
	private String highIdentification;

	/**
	 * 学制类型
	 */
	@ExcelAttribute(name = "学制类型", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION_SYSTEM)
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "学制类型")
	@ExcelProperty("学制类型")
	private String educationSystem;

	/**
	 * 入学时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "入学时间")
	@ExcelProperty("入学时间")
	private String entryDate;

	/**
	 * 结业日期
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "结业日期")
	@ExcelProperty("毕业日期")
	private String gradutionDate;

	/**
	 * 证书名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 50)
	@Schema(description = "证书名称")
	@ExcelProperty("证书名称")
	private String certificationName;

	/**
	 * 备注
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Max(value = 200)
	@Schema(description = "备注")
	@ExcelProperty("备注")
	private String remark;

}
