package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 入职确认信息社保已购买记录
 *
 * @author huych
 * @date 2025-09-30 16:41:57
 */
@Data
public class TSocialPreDetailVo implements Serializable {
	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("ID")
	@Schema(description = "ID")
	private String id;
	/**
	 * 社保缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地-省", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-省不能超过32个字符")
	@ExcelProperty("社保缴纳地-省")
	@Schema(description = "社保缴纳地-省")
	private String socialProvince;
	/**
	 * 社保缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-市不能超过32个字符")
	@ExcelProperty("社保缴纳地-市")
	@Schema(description = "社保缴纳地-市")
	private String socialCity;
	/**
	 * 社保缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-县不能超过32个字符")
	@ExcelProperty("社保缴纳地-县")
	@Schema(description = "社保缴纳地-县")
	private String socialTown;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Length(max = 50, message = "社保户名称不能超过50个字符")
	@ExcelProperty("社保户名称")
	@Schema(description = "社保户名称")
	private String socialHouseholdName;
	/**
	 * 入职确认信息主表id
	 */
	@ExcelAttribute(name = "入职确认信息主表id", maxLength = 36)
	@Length(max = 36, message = "入职确认信息主表id不能超过36个字符")
	@ExcelProperty("入职确认信息主表id")
	@Schema(description = "入职确认信息主表id")
	private String registerId;

	/**
	 * 缴费政策类型 0-最低 1-自定义 2-最高
	 */
	private String paymentType;

	/**
	 * 社保状态
	 */
	private String socialStatus;
	/**
	 * 派单人
	 */
	@ExcelAttribute(name = "派单人", maxLength = 64)
	@Length(max = 64, message = "派单人不能超过64个字符")
	@ExcelProperty("派单人")
	@Schema(description = "派单人")
	private String dispatchName;
	/**
	 * 派单时间
	 */
	@ExcelAttribute(name = "派单时间")
	@ExcelProperty("派单时间")
	@Schema(description = "派单时间")
	private String dispatchTime;

}
