/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascEditLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplateDetail;
import com.yifu.cloud.plus.v1.yifu.archives.service.TFascEditLogService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TFascTemplateDetailService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateDetailSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 法大大专业版模板映射表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tfasctemplatedetail")
@Tag(name = "法大大专业版模板映射表管理")
public class TFascTemplateDetailController {

	private final TFascTemplateDetailService tFascTemplateDetailService;

	private final TFascEditLogService tFascEditLogService;

	/**
	 * 简单分页查询
	 *
	 * @param page                分页对象
	 * @param tFascTemplateDetail 法大大专业版模板映射表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TFascTemplateDetail>> getTFascTemplateDetailPage(Page<TFascTemplateDetail> page, TFascTemplateDetailSearchVo tFascTemplateDetail) {
		return new R<>(tFascTemplateDetailService.getTFascTemplateDetailPage(page, tFascTemplateDetail));
	}
	
	/**
	 * @Description: 重新刷新主模板表的必填是否已填
	 * @Author: hgw
	 * @Date: 2025/10/10 16:33
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "重新刷新主模板表的必填是否已填")
	@SysLog(value = "重新刷新主模板表的必填是否已填")
	@GetMapping("/initFascTemplateIsMust")
	public R<String> initFascTemplateIsMust(@RequestParam(required = false) String templateId) {
		return tFascTemplateDetailService.initFascTemplateIsMust(templateId);
	}

	/**
	 * 不分页查询
	 *
	 * @param tFascTemplateDetail 法大大专业版模板映射表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TFascTemplateDetail>> getTFascTemplateDetailNoPage(@RequestBody TFascTemplateDetailSearchVo tFascTemplateDetail) {
		return R.ok(tFascTemplateDetailService.noPageDiy(tFascTemplateDetail));
	}

	/**
	 * 通过id查询法大大专业版模板映射表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tfasctemplatedetail_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tfasctemplatedetail_get')")
	public R<TFascTemplateDetail> getById(@PathVariable("id") String id) {
		return R.ok(tFascTemplateDetailService.getById(id));
	}

	/**
	 * 修改法大大专业版模板映射表
	 *
	 * @param tFascTemplateDetail 法大大专业版模板映射表
	 * @return R
	 */
	@Operation(summary = "修改法大大专业版模板映射表", description = "修改法大大专业版模板映射表：hasPermission('archives_tfasctemplatedetail_edit')")
	@SysLog("修改法大大专业版模板映射表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('archives_tfasctemplatedetail_edit')")
	public R<String> updateById(@RequestBody TFascTemplateDetail tFascTemplateDetail) {
		if (Common.isEmpty(tFascTemplateDetail.getId())) {
			return R.failed("ID不能为空");
		}
		if (Common.isEmpty(tFascTemplateDetail.getHrFieldId()) || Common.isEmpty(tFascTemplateDetail.getHrField())) {
			return R.failed("皖信字段不能为空");
		}
		TFascTemplateDetail old = tFascTemplateDetailService.getById(tFascTemplateDetail.getId());
		if (old == null) {
			return R.failed("根据ID未找到原信息");
		}
		// 更新映射表
		tFascTemplateDetailService.updateById(tFascTemplateDetail);

		// 改没改合同，都加日志
		TFascEditLog tFascEditLog = new TFascEditLog();
		tFascEditLog.setMainId(tFascTemplateDetail.getId());
		tFascEditLog.setMainType(CommonConstants.TWO_STRING);
		String editContent = "“皖信字段”由“";
		if (Common.isEmpty(old.getHrField())) {
			editContent += "空”";
		} else {
			editContent += old.getHrField() + "”";
		}
		editContent += "→“";
		if (Common.isNotNull(tFascTemplateDetail.getHrField())) {
			editContent += tFascTemplateDetail.getHrField() + "”";
		} else {
			editContent += "空”";
		}
		// 判断是否已配置有没有变更：0未配置 1已配置
		if (Common.isEmpty(old.getIsEdit())) {
			if (Common.isNotNull(tFascTemplateDetail.getIsEdit()) && CommonConstants.ONE_STRING.equals(tFascTemplateDetail.getIsEdit())) {
				editContent += "；“是否已配置”由“未配置”→“已配置”";
			}
		} else if (Common.isEmpty(tFascTemplateDetail.getIsEdit())) {
			editContent += "；“是否已配置”由“已配置”→“未配置”";
		} else if (!old.getIsEdit().equals(tFascTemplateDetail.getIsEdit())) {
			if (CommonConstants.ONE_STRING.equals(tFascTemplateDetail.getIsEdit())) {
				editContent += "；“是否已配置”由“未配置”→“已配置”";
			} else {
				editContent += "；“是否已配置”由“已配置”→“未配置”";
			}
		}
		tFascEditLog.setEditContent(editContent);
		tFascEditLogService.save(tFascEditLog);
		// 重新刷新主模板表的必填是否已填
		tFascTemplateDetailService.initFascTemplateIsMust(old.getSignTemplateId());
		return R.ok();
	}

	/**
	 * 法大大专业版模板映射表 批量维护
	 *
	 * @author hgw
	 * @date 2025-09-30 16:29:28
	 **/
	@SneakyThrows
	@Operation(description = "批量维护法大大专业版模板映射表 hasPermission('archives_tfasctemplatedetail-batch-update')")
	@SysLog("批量维护法大大专业版模板映射表")
	@PostMapping("/batchUpdateFascDetail")
	public R<List<ErrorMessage>> batchUpdateFascDetail(@RequestBody MultipartFile file) {
		return tFascTemplateDetailService.batchUpdateFascDetail(file.getInputStream());
	}

	/**
	 * 法大大专业版模板映射表 批量导出
	 *
	 * @author hgw
	 * @date 2025-09-30 16:29:28
	 **/
	@Operation(description = "导出法大大专业版模板映射表 hasPermission('archives_tfasctemplatedetail-export')")
	@PostMapping("/export")
	@SysLog("导出法大大专业版模板映射表")
	public void export(HttpServletResponse response, @RequestBody TFascTemplateDetailSearchVo searchVo) {
		tFascTemplateDetailService.listExport(response, searchVo);
	}
}
