package com.yifu.cloud.plus.v1.yifu.permission.vo;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysUserInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 36, message = "主键 不能超过36 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 36)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String fdId;
	/**
	 * ele表-员工姓名
	 */
	@Length(max = 200, message = "ele表-员工姓名 不能超过200 个字符")
	@ExcelAttribute(name = "ele表-员工姓名", maxLength = 200)
	@Schema(description = "ele表-员工姓名")
	@ExcelProperty("ele表-员工姓名")
	private String fdName;
	/**
	 * per表-登录账号
	 */
	@Length(max = 200, message = "per表-登录账号 不能超过200 个字符")
	@ExcelAttribute(name = "per表-登录账号", maxLength = 200)
	@Schema(description = "per表-登录账号")
	@ExcelProperty("per表-登录账号")
	private String fdLoginName;
	/**
	 * ele表-所在部门
	 */
	@Length(max = 450, message = "ele表-所在部门 不能超过450 个字符")
	@ExcelAttribute(name = "ele表-所在部门", maxLength = 450)
	@Schema(description = "ele表-所在部门")
	@ExcelProperty("ele表-所在部门")
	private String fdLdapDn;
	/**
	 * 所在部门
	 */
	@Length(max = 100, message = "所在部门 不能超过100 个字符")
	@ExcelAttribute(name = "所在部门", maxLength = 100)
	@Schema(description = "所在部门")
	@ExcelProperty("所在部门")
	private String fdDeptName;
	/**
	 * per表-手机号
	 */
	@Length(max = 150, message = "per表-手机号 不能超过150 个字符")
	@ExcelAttribute(name = "per表-手机号", maxLength = 150)
	@Schema(description = "per表-手机号")
	@ExcelProperty("per表-手机号")
	private String fdMobileNo;
	/**
	 * per表-邮箱
	 */
	@Length(max = 200, message = "per表-邮箱 不能超过200 个字符")
	@ExcelAttribute(name = "per表-邮箱", maxLength = 200)
	@Schema(description = "per表-邮箱")
	@ExcelProperty("per表-邮箱")
	private String fdEmail;
	/**
	 * 状态：0正常；1冻结
	 */
	@NotBlank(message = "状态：0正常；1冻结 不能为空")
	@ExcelAttribute(name = "状态：0正常；1冻结", isNotEmpty = true, errorInfo = "状态：0正常；1冻结 不能为空")
	@Schema(description = "状态：0正常；1冻结")
	@ExcelProperty("状态：0正常；1冻结")
	private Integer status;
	/**
	 * 角色名称合集
	 */
	@Length(max = 200, message = "角色名称合集 不能超过200 个字符")
	@ExcelAttribute(name = "角色名称合集", maxLength = 200)
	@Schema(description = "角色名称合集")
	@ExcelProperty("角色名称合集")
	private String roleNames;
	/**
	 * 创建人id
	 */
	@Length(max = 36, message = "创建人id 不能超过36 个字符")
	@ExcelAttribute(name = "创建人id", maxLength = 36)
	@Schema(description = "创建人id")
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 200, message = "创建人姓名 不能超过200 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 200)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 200, message = "更新人id 不能超过200 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 200)
	@Schema(description = "更新人id")
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private LocalDateTime updateTime;

}
