package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryTaxConfig;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 个税比例及速算扣除数的配置表
 *
 * @author fxj
 * @date 2022-08-06 13:00
 */
@Mapper
public interface TSalaryTaxConfigMapper extends BaseMapper<TSalaryTaxConfig> {
  /**
    * 个税比例及速算扣除数的配置表简单分页查询
    * @param tSalaryTaxConfig 个税比例及速算扣除数的配置表
    * @return
    */
  IPage<TSalaryTaxConfig> getTSalaryTaxConfigPage(Page page, @Param("tSalaryTaxConfig") TSalaryTaxConfig tSalaryTaxConfig);

  /**
   * @param tSalaryTaxConfig
   * @Description: 获取个税配置
   * @Author: hgw
   * @Date: 2019/10/8 14:39
   * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>
   **/
  List<TSalaryTaxConfig> getTaxConfigByPersonList(@Param("tSalaryTaxConfig") TSalaryTaxConfig tSalaryTaxConfig);

  /**
   * @param tSalaryTaxConfig
   * @Description: 获取年终奖配置
   * @Author: hgw
   * @Date: 2019/10/8 14:40
   * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>
   **/
  List<TSalaryTaxConfig> getTaxConfigByAnnualBonusList(@Param("tSalaryTaxConfig") TSalaryTaxConfig tSalaryTaxConfig);

  /**
   * @param tSalaryTaxConfig
   * @Description: 实发倒推
   * @Author: hgw
   * @Date: 2023/5/16 10:33
   * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryTaxConfig>
   **/
  List<TSalaryTaxConfig> getTaxConfigByActualList(@Param("tSalaryTaxConfig") TSalaryTaxConfig tSalaryTaxConfig);


}
