/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TBankSet;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TBankSetSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 开户行配置表
 *
 * @author hgw
 * @date 2023-03-06 11:54:21
 */
public interface TBankSetService extends IService<TBankSet> {
    /**
     * 开户行配置表简单分页查询
     * @param tBankSet 开户行配置表
     * @return
     */
    IPage<TBankSet> getTBankSetPage(Page<TBankSet> page, TBankSetSearchVo tBankSet);

	/**
	 * @param tBankSet
	 * @Description: 获取Id和Name，当前给C端预入职使用，其他接口也可以使用，但是回传参数只有2个
	 * @Author: hgw
	 * @Date: 2024/7/15 16:59
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TBankSet>
	 **/
	List<TBankSet> getTBankSetIdNameList(TBankSetSearchVo tBankSet);

	/**
	 * @param bankName 开户行
	 * @Description: 获取Map
	 * @Author: hgw
	 * @Date: 2023/3/6 15:23
	 * @return: java.util.Map<java.lang.String, java.lang.String>
	 **/
	Map<String, String> getBankMap(String bankName);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TBankSetSearchVo searchVo);

    List<TBankSet> noPageDiy(TBankSetSearchVo searchVo);

	/**
	 * @param bankName
	 * @param id
	 * @Description: 获取list
	 * @Author: hgw
	 * @Date: 2023/3/10 18:08
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TBankSet>
	 **/
	List<TBankSet> getList(String bankName, String id);
}
