/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuthDiySql;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 数据权限配置相关mapper
 * @Author: hgw
 * @Date: 2022/6/7 14:40
 * @return:
 **/
@Mapper
public interface SysDataAuthDiySqlMapper extends BaseMapper<SysDataAuthDiySql> {
	// 清空
	int deleteDiySqlByAuthId(@Param("mainId") String mainId);

	// 根据权限主表id，查询全部
	List<SysDataAuthDiySql> getByMainId(@Param("mainId") String mainId);
}
