package com.yifu.cloud.plus.v1.yifu.common.security.component;


import com.yifu.cloud.plus.v1.yifu.common.security.token.WxAuthenticationToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 手机验证码登陆
 */
@Slf4j
public class WxAuthenticationProvider extends MyAbstractUserDetailsAuthenticationProvider {

    private UserDetailsService userDetailsService;


    @Override
    protected void additionalAuthenticationChecks(UserDetails var1, Authentication authentication) throws AuthenticationException {

//        if(authentication.getCredentials() == null) {
//            this.logger.debug("Authentication failed: no credentials provided");
//            throw new BadCredentialsException(this.messages.getMessage("PhoneAuthenticationProvider.badCredentials", "Bad credentials"));
//        }
    }

    @Override
    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        WxAuthenticationToken result = new WxAuthenticationToken(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }

    @Override
    protected UserDetails retrieveUser(String wxUserName, Authentication authentication) throws AuthenticationException {
        UserDetails loadedUser;
//        String presentedPassword = authentication.getCredentials().toString();
//
//        // 验证码验证，调用公共服务查询 key 为authentication.getPrincipal()的value， 并判断其与验证码是否匹配
//        String code = redisUtil.get(wxUserName).toString();
//        if(!code.equals(presentedPassword)){
//            this.logger.debug("Authentication failed: verifyCode does not match stored value");
//            throw new BadCredentialsException(this.messages.getMessage("PhoneAuthenticationProvider.badCredentials", "Bad verifyCode"));
//        }
        try {
            loadedUser = this.getUserDetailsService().loadUserByUsername(wxUserName);
			log.error(wxUserName+":"+loadedUser.getUsername());
        } catch (UsernameNotFoundException var6) {
            throw var6;
        } catch (Exception var7) {
            log.info("WxAuthenticationProvider>>>>>>",var7);
            throw new InternalAuthenticationServiceException(var7.getMessage(), var7);
        }

        if(loadedUser == null) {
            throw new InternalAuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        } else {
            return loadedUser;
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return WxAuthenticationToken.class.isAssignableFrom(authentication);
    }


    public UserDetailsService getUserDetailsService() {
        return userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}
