/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsBonus;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsBonusImportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsBonusSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 全年一次性奖金申报表
 *
 * @author huyc
 * @date 2022-08-14 21:31:15
 */
public interface TStatisticsBonusService extends IService<TStatisticsBonus> {
    /**
     * 全年一次性奖金申报表简单分页查询
     * @param tStatisticsBonus 全年一次性奖金申报表
     * @return
     */
    IPage<TStatisticsBonus> getTStatisticsBonusPage(Page<TStatisticsBonus> page, TStatisticsBonusSearchVo tStatisticsBonus);

	/**
	 * 全年一次性奖金申报表导出
	 * @param searchVo
	 * @return
	 */
    void listExport(HttpServletResponse response, TStatisticsBonusSearchVo searchVo);

	/**
	 * 全年一次性奖金测算
	 * @param deptId 部门id
	 * @return
	 */
	void importDiy(HttpServletResponse response, List<TStatisticsBonusImportVo> list, String deptId);

    List<TStatisticsBonus> noPageDiy(TStatisticsBonusSearchVo searchVo);

	/**
	 * 批量删除全年一次性奖金申报表
	 * @param declareMonth 申报月份
	 * @return
	 */
	R batchDelete(String declareMonth);

	/**	生成全年一次性奖金
	 * @param
	 * @return
	 **/
	R doStatisticsBonus();
}
