/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialSoldierPushService;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialSoldierService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * 社保士兵
 *
 * @author hgw
 * @date 2024-5-8 14:37:00
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialsoldier")
@Tag(name = "社保士兵")
public class TSocialSoldierController {

	private final TSocialSoldierService tSocialSoldierService;
	private final TSocialSoldierPushService tSocialSoldierPushService;

	/**
	 * @param addId 任务id，可为空
	 * @Description: 1获取社保士兵状态
	 * @Author: hgw
	 * @Date: 2024/5/11 19:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "获取社保士兵状态")
	@GetMapping("/getFiveJob")
	public R<String> getFiveJob(@RequestParam(required = false) String addId) {
		return tSocialSoldierService.getFiveJob(addId);
	}

	/**
	 * @param dispatchIdList 派单id
	 * @Description: 推送社保士兵
	 * @Author: hgw
	 * @Date: 2024/5/11 19:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "推送社保士兵")
	@PostMapping("/pushSoldier")
	public R<String> pushSoldier(@RequestBody(required = false) List<String> dispatchIdList) {
		return tSocialSoldierPushService.pushSoldier(dispatchIdList);
	}

	/**
	 * @Description: 1定时任务获取社保士兵状态
	 * @Author: hgw
	 * @Date: 2024/5/11 19:26
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "1定时任务获取社保士兵状态")
	@PostMapping("/inner/doInnerGetFiveJob")
	@SysLog("1每日定时任务获取社保士兵状态")
	@Inner
	public R<String> doInnerGetFiveJob() {
		return tSocialSoldierService.getFiveJob(null);
	}

	/**
	 * @Description: 2定时任务推送社保士兵
	 * @Author: hgw
	 * @Date: 2024/5/11 19:26
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "2定时任务推送社保士兵")
	@PostMapping("/inner/doInnerPushSoldier")
	@SysLog("2每日定时任务推送社保士兵")
	@Inner
	public R<String> doInnerPushSoldier() {
		return tSocialSoldierPushService.pushSoldier(null);
	}

	/**
	 * @Description: 3每日定时任务推送社保士兵审核结果查询
	 * @Author: hgw
	 * @Date: 2024-5-24 17:01:56
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "3每日定时任务推送社保士兵审核结果查询")
	@PostMapping("/inner/doInnerPushSoldierByAudit")
	@SysLog("4每日定时任务推送社保士兵审核结果查询")
	@Inner
	public R<String> doInnerPushSoldierByAudit() {
		return tSocialSoldierPushService.pushSoldierByAudit();
	}

	/**
	 * @Description: 4每日定时任务获取社保士兵审核结果查询
	 * @Author: hgw
	 * @Date: 2024-5-24 17:02:00
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "4每日定时任务获取社保士兵审核结果查询")
	@PostMapping("/inner/doInnerGetSixJobByAudit")
	@SysLog("4每日定时任务获取社保士兵审核结果查询")
	@Inner
	public R<String> doInnerGetSixJobByAudit() {
		return tSocialSoldierService.getSixJobByAudit();
	}

	/**
	 * @Description: 5推送工资申报、调整（实缴使用）
	 * @Author: hgw
	 * @Date: 2024-5-30 17:32:43
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "5每月5号推送工资申报、调整（实缴使用）")
	@PostMapping("/inner/doInnerPushSalaryByShenBao")
	@SysLog("5每月5号推送工资申报、调整（实缴使用）")
	@Inner
	public R<String> doInnerPushSalaryByShenBao() {
		return tSocialSoldierPushService.pushSalaryByShenBao();
	}

	/**
	 * @Description: 6每月6号推送实缴3张表查询
	 * @Author: hgw
	 * @Date: 2024-5-31 16:04:09
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "6每月6号1点推送实缴3张表查询")
	@PostMapping("/inner/doPushPaymentThree")
	@SysLog("6每月6号推送实缴3张表查询")
	@Inner
	public R<String> doPushPaymentThree() {
		return tSocialSoldierPushService.pushPaymentThree(null,false);
	}

	/**
	 * @Description: 7每月6号定时任务获取社保士兵实缴3张表
	 * @Author: hgw
	 * @Date: 2024-5-30 18:00:00
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "7每月6号3点定时任务获取社保士兵实缴3张表")
	@PostMapping("/inner/doInnerGetPaymentThree")
	@SysLog("7每月6号定时任务获取社保士兵实缴3张表")
	@Inner
	public R<String> doInnerGetPaymentThree() {
		return tSocialSoldierService.doInnerGetPaymentThree();
	}

	/**
	 * @Description: 推送重新办理任务
	 * @Author: hgw
	 * @Date: 2024/5/11 19:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "推送重新办理任务")
	@GetMapping("/pushReHandle")
	public R<String> pushReHandle(@RequestParam String parentId) {
		return tSocialSoldierPushService.pushPaymentThree(parentId, true);
	}

	/**
	 * @param parentId 主表id
	 * @Description: 获取重新办理结果
	 * @Author: hgw
	 * @Date: 2024/5/11 19:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "获取重新办理结果")
	@GetMapping("/getReHandle")
	public R<String> getReHandle(@RequestParam String parentId) {
		return tSocialSoldierService.getReHandle(parentId);
	}

	/**
	 * @Description: 文件组装zip的Demo（测试附件使用，不删除）
	 * @Author: hgw
	 * @Date: 2024-6-11 14:27:50
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "文件组装zip的Demo")
	@PostMapping("/getZip")
	public R<String> getZip(@RequestBody MultipartFile zipFile) {
		return tSocialSoldierService.getZip(zipFile);
	}

}
