package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;


/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_prove_apply")
@Schema(description = "工资证明申请表")
public class TProveApply extends Model<TProveApply> {
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键", name = "id")
	private String id;
	/**
	 * 员工id
	 */
	@NotBlank(message = "员工id不能为空")
	@Length(max = 32, message = "员工id不能超过32个字符")
	@ExcelAttribute(name = "员工id", isNotEmpty = true, errorInfo = "员工id不能为空", maxLength = 32)
	@Schema(description = "员工id", name = "employeeInfo")
	private String employeeInfo;
	/**
	 * 申请人
	 */
	@ExcelAttribute(name = "申请人", isNotEmpty = true, errorInfo = "申请人不能为空")
	@Schema(description = "申请人", name = "creatUser")
	private String creatUser;
	@Schema(description = "申请人名称")
	private String creatUserName;
	/**
	 * 申请日期
	 */
	@ExcelAttribute(name = "申请日期", isNotEmpty = true, errorInfo = "申请日期不能为空")
	@Schema(description = "申请日期", name = "creatDate")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date creatDate;
	/**
	 * 开始月
	 */
	@NotBlank(message = "开始月不能为空")
	@Length(max = 6, message = "开始月不能超过6个字符")
	@ExcelAttribute(name = "开始月", isNotEmpty = true, errorInfo = "开始月不能为空", maxLength = 6)
	@Schema(description = "开始月", name = "startMonth")
	private String startMonth;
	/**
	 * 结束月
	 */
	@NotBlank(message = "结束月不能为空")
	@Length(max = 6, message = "结束月不能超过6个字符")
	@ExcelAttribute(name = "结束月", isNotEmpty = true, errorInfo = "结束月不能为空", maxLength = 6)
	@Schema(description = "结束月", name = "endMonth")
	private String endMonth;
	/**
	 * 证明的工资
	 */
	@NotNull(message = "证明的工资不能为空")
	@ExcelAttribute(name = "证明的工资")
	@Schema(description = "证明的工资", name = "proveSalary")
	private BigDecimal proveSalary;
	/**
	 * 申请理由
	 */
	@Length(max = 100, message = "申请理由不能超过100个字符")
	@ExcelAttribute(name = "申请理由", maxLength = 100)
	@Schema(description = "申请理由", name = "applyReason")
	private String applyReason;
	/**
	 * 审核状态 0待审核1审核通过2审核不通过
	 */
	@Length(max = 1, message = "审核状态不能超过1个字符")
	@Schema(description = "审核状态 0待审核1审核通过2审核不通过", name = "auditStatus")
	private String auditStatus;
	/**
	 * 审核人
	 */
	@ExcelAttribute(name = "审核人")
	@Schema(description = "审核人", name = "auditUser")
	private String auditUser;
	@Schema(description = "审核人名称")
	private String auditUserName;
	/**
	 * 审核日期
	 */
	@ExcelAttribute(name = "审核日期")
	@Schema(description = "审核日期", name = "auditDate")
	private LocalDate auditDate;

 /*   @Length(max = 100, message = "附件id逗号隔开不能超过100个字符")
    @ExcelAttribute(name = "附件id逗号隔开", maxLength = 100)
    @Schema(description = "附件id逗号隔开", name = "fileId")
    private String fileId;*/
	/**
	 * 0实发平均1应发平均
	 */
	@NotBlank(message = "实发应发不能为空")
	@Length(max = 1, message = "实发应发类型不能超过1个字符")
	@Schema(description = "0实发平均1应发平均", name = "sumType")
	private String sumType;
	/**
	 * 实际工资
	 */
	@NotNull(message = "实际工资不能为空")
	@ExcelAttribute(name = "实际工资")
	@Schema(description = "实际工资", name = "salary")
	private BigDecimal salary;

	/**
	 * 员工身份证号
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:27
	 * @return
	 **/
	@Schema(description = "员工身份证号")
	private String employeeIdCard;

	@Schema(description = "员工姓名")
	@ExcelAttribute(name = "姓名")
	private String employeeName;
	/**
	 * 结算主体id
	 *
	 * @Author pwang
	 * @Date 2019-11-07 10:27
	 * @return
	 **/
	@Schema(description = "结算主体id")
	private String settleDomain;
	@Schema(description = "结算主体名称")
	private String settleDomainName;

}
