package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/7/19
 * @Description  派单新增合同
 * @Version 1.0
 */
@Data
public class EmpContractDispatchVo implements Serializable {
	/**
	 * 合同主键ID
	 */
	@Schema(description = "合同主键ID", name = "empId")
	private String id;

	/**
	 * 员工主键
	 */
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelAttribute(name = "员工主键", maxLength = 32)
	@Schema(description = "员工主键", name = "empId")
	private String empId;
	/**
	 * 员工编码
	 */
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@Schema(description = "员工编码", name = "empNo")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20, isIdCard = true, needExport = true)
	@Schema(description = "身份证号", name = "empIdcard")
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型", errorInfo = "员工类型不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@TableField(exist = false)
	private String empNatrue;
	/**
	 * 项目编码
	 */
	@Length(max = 20, message = "项目编码不能超过20个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 签订类型（字典）
	 */
	@NotBlank(message = "签订类型不能为空")
	@Length(max = 20, message = "签订类型不能超过20个字符")
	@ExcelAttribute(name = "签订类型", isNotEmpty = true, errorInfo = "签订类型不能为空", maxLength = 20, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_SITUATION_TYPE)
	@Schema(description = "签订类型（字典）", name = "situation")
	private String situation;

	/**
	 * 合同类型
	 */
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	/**
	 * 业务细分
	 */
	@NotBlank(message = "业务细分不能为空")
	@Length(max = 32, message = "业务细分不能超过32个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;

	/**
	 * 合同甲方
	 */
	@Length(max = 50, message = "原因说明不能超过200个字符")
	@ExcelAttribute(name = "合同甲方", maxLength = 50, needExport = true)
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	private String contractParty;

	/**
	 * 签订期限
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	/**
	 * 合同起始时间
	 */
	@NotBlank(message = "起始日期不能为空")
	@DateTimeFormat("yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ExcelAttribute(name = "起始日期", isDate = true)
	@Schema(description = "起始日期", name = "contractStart")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "截止日期", needExport = true, isDate = true)
	@DateTimeFormat("yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Schema(description = "截止日期", name = "contractEnd")
	private Date contractEnd;

	/**
	 * 合同岗位
	 */
	@Length(max = 32, message = "合同岗位不能超过32个字符")
	@ExcelAttribute(name = "合同岗位", maxLength = 32, needExport = true)
	@Schema(description = "合同岗位", name = "post")
	private String post;

	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 32, message = "工时制不能超过32个字符")
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
	private String workingHours;

	/**
	 * 备注
	 */
	@Length(max = 200, message = "不能超过200个字符")
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Schema(description = "备注", name = "remark")
	private String remark;

	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省", maxLength = 32, isDataId = true, isArea = true, parentField = "")
	@Schema(description = "档案-省", name = "fileProvince")
	private Integer fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市", maxLength = 32, isDataId = true, isArea = true, parentField = "fileProvince")
	@Schema(description = "档案-市", name = "fileCity")
	private Integer fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县", maxLength = 32, isDataId = true, isArea = true, parentField = "fileCity")
	@Schema(description = "档案-县", name = "fileTown")
	private Integer fileTown;

	/**
	 * 客户id
	 */
	@Schema(description = "客户id")
	private String customerId;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String unitNo;

	/**
	 * 项目
	 */
	@NotBlank(message = "项目不能为空")
	@Length(max = 32, message = "项目不能超过32个字符")
	@ExcelAttribute(name = "项目", errorInfo = "项目不能为空", isOrgan = true, maxLength = 32)
	@Schema(description = "项目", name = "settleDomain")
	private String settleDomain;

	/**
	 * 项目名称
	 */
	@Length(max = 128, message = "项目名称不能超过128个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 128)
	@Schema(description = "项目名称", name = "subjectDepart")
	private String subjectDepart;
	/**
	 * 客户名称
	 */
	@Length(max = 128, message = "客户名称不能超过128个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 128)
	@Schema(description = "客户名称", name = "subjectUnit")
	private String subjectUnit;

	/**
	 * 合同年限
	 */
	@NotBlank(message = "合同年限不能为空")
	@ExcelAttribute(name = "合同年限", errorInfo = "合同年限不能为空")
	@Schema(description = "合同年限", name = "contractTerm")
	private String contractTerm;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	/**
	 * 创建者
	 */
	@Schema(description = "创建人")
	@TableField(fill = FieldFill.INSERT)
	@ExcelIgnore
	private String createBy;

}
