package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 员工伤残excel 对应的实体
 *
 * @author fxz
 * @date 2022/3/21
 */
@Data
@ColumnWidth(30)
public class EmpEducationExcelVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true, errorInfo = "员工姓名不可为空",maxLength = 20)
	@NotNull(message = "员工姓名不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号",isNotEmpty = true, errorInfo = "员工身份证不可为空", maxLength = 20)
	@NotNull(message = "员工身份证不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="身份证号")
	private String empIdcard;

	/**
	 * 学校名称
	 */
	@ExcelAttribute(name = "学校",isNotEmpty = true, errorInfo = "学校不可为空",maxLength = 50)
	@NotNull(message = "学校不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学校")
	private String school;

	/**
	 * 院系名称
	 */
	@ExcelAttribute(name = "院系名称",maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="院系名称")
	private String collageSystem;

	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业",isNotEmpty = true, errorInfo = "专业不可为空",maxLength = 50)
	@NotNull(message = "专业不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="专业")
	private String major;

	/**
	 * 学历名称
	 */
	@ExcelAttribute(name = "学历",isNotEmpty = true, errorInfo = "学历不可为空",isDataId = true,dataType = ExcelAttributeConstants.EDUCATION)
	@NotNull(message = "学历不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历")
	private String educationName;

	/**
	 * 学历类型：全日制、自考、函授等
	 */
	@ExcelAttribute(name = "学历类型",isDataId = true,dataType = ExcelAttributeConstants.EDUCATION_TYPE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历类型")
	private String type;

	/**
	 * 最高学历标识0是/1否
	 */
	@ExcelAttribute(name = "最高学历",isNotEmpty = true, errorInfo = "最高学历不可为空",readConverterExp = "0=是,1=否")
	@NotNull(message = "最高学历标识不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="最高学历")
	private String highIdentification;

	/**
	 * 学制类型：四年、三年、五年、二年
	 */
	@ExcelAttribute(name = "学制类型",isDataId = true,dataType = ExcelAttributeConstants.EDUCATION_SYSTEM)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学制类型")
	private String educationSystem;

	/**
	 * 入学时间
	 */
	@ExcelAttribute(name = "入学时间",isNotEmpty = true, errorInfo = "入学时间不可为空",isDate = true)
	@NotNull(message = "入学时间不可为空")
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="入学时间")
	private Date entryDate;

	/**
	 * 结业日期
	 */
	@ExcelAttribute(name = "毕业时间",isNotEmpty = true, errorInfo = "毕业时间不可为空",isDate = true)
	@NotNull(message = "毕业时间不可为空")
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="毕业时间")
	private Date gradutionDate;

	/**
	 * 证书名称
	 */
	@ExcelAttribute(name = "证书名称",maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="证书名称")
	private String certificationName;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注",maxLength = 200)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="备注")
	private String remark;


	/*JSR303 是一套JavaBean参数校验的标准，它定义了很多常用的校验注解，我们可以直接将这些注解加在我们JavaBean的属性上面，就可以在需要校验的时候进行校验了。注解如下：
	参考配置
	@Null 限制只能为null
	@NotNull 限制必须不为null
	@AssertFalse 限制必须为false
	@AssertTrue 限制必须为true
	@DecimalMax(value) 限制必须为一个不大于指定值的数字
	@DecimalMin(value) 限制必须为一个不小于指定值的数字
	@Digits(integer,fraction) 限制必须为一个小数，且整数部分的位数不能超过integer，小数部分的位数不能超过fraction
	@Future 限制必须是一个将来的日期
	@Max(value) 限制必须为一个不大于指定值的数字
	@Min(value) 限制必须为一个不小于指定值的数字
	@Past 限制必须是一个过去的日期
	@Pattern(value) 限制必须符合指定的正则表达式
	@Size(max,min) 限制字符长度必须在min到max之间
	@Past 验证注解的元素值（日期类型）比当前时间早
	@NotEmpty 验证注解的元素值不为null且不为空（字符串长度不为0、集合大小不为0）
	@NotBlank 验证注解的元素值不为空（不为null、去除首位空格后长度为0），不同于@NotEmpty，@NotBlank只应用于字符串且在比较时会去除字符串的空格
	@Email 验证注解的元素值是Email，也可以通过正则表达式和flag指定自定义的email格式*/

}
