/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 员工合同-批量操作的VO
 *
 * @author hgw
 * @date 2022-7-1 17:40:40
 */
@Data
@Schema(description = "员工合同-批量操作的VO")
public class EmployeeContractVO extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20, isIdCard = true, needExport = true)
	@Schema(description = "身份证号", name = "empIdcard")
	private String empIdcard;

	/**
	 * 项目编码
	 */
	@Length(max = 20, message = "项目编码不能超过20个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 签订类型（字典）
	 */
	@NotBlank(message = "签订类型不能为空")
	@Length(max = 20, message = "签订类型不能超过20个字符")
	@ExcelAttribute(name = "签订类型", isNotEmpty = true, errorInfo = "签订类型不能为空", maxLength = 20, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_SITUATION_TYPE)
	@Schema(description = "签订类型（字典）", name = "situation")
	private String situation;

	/**
	 * 合同类型
	 */
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	/**
	 * 业务细分
	 */
	@NotBlank(message = "业务细分不能为空")
	@Length(max = 32, message = "业务细分不能超过32个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;

	/**
	 * 原因说明
	 */
	@Length(max = 200, message = "原因说明不能超过200个字符")
	@ExcelAttribute(name = "原因说明", maxLength = 200, needExport = true)
	@Schema(description = "原因说明", name = "reason")
	private String reason;

	/**
	 * 合同甲方
	 */
	@Length(max = 50, message = "原因说明不能超过200个字符")
	@ExcelAttribute(name = "合同甲方", maxLength = 50, needExport = true)
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	private String contractParty;

	/**
	 * 签订期限
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	/**
	 * 合同起始时间
	 */
	@NotBlank(message = "起始日期不能为空")
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "起始日期", isDate = true)
	@Schema(description = "起始日期", name = "contractStart")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "截止日期", needExport = true, isDate = true)
	@DateTimeFormat("yyyy-MM-dd")
	@Schema(description = "截止日期", name = "contractEnd")
	private Date contractEnd;

	/**
	 * 合同岗位
	 */
	@Length(max = 32, message = "合同岗位不能超过32个字符")
	@ExcelAttribute(name = "合同岗位", maxLength = 32, needExport = true)
	@Schema(description = "合同岗位", name = "post")
	private String post;

	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 32, message = "工时制不能超过32个字符")
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
	private String workingHours;

	/**
	 * 合同编码
	 */
	@NotBlank(message = "合同编码不能为空")
	@Length(max = 50, message = "合同编码不能超过50个字符")
	@ExcelAttribute(name = "合同编码", maxLength = 50)
	@Schema(description = "合同编码", name = "contractNo")
	private String contractNo;

	/**
	 * 档案柜号
	 */
	@Length(max = 50, message = "档案柜号不能超过50个字符")
	@ExcelAttribute(name = "档案柜号", maxLength = 50)
	@Schema(description = "档案柜号", name = "fileCabinetNo")
	private String fileCabinetNo;
	/**
	 * 离职日期
	 */
	@ExcelAttribute(name = "离职日期")
	@Schema(description = "离职日期")
	private String leaveDate;
	/**
	 * 终止原因
	 */
	@ExcelAttribute(name = "终止原因", maxLength = 32)
	@Schema(description = "终止原因")
	private String reduceReason;
	/**
	 * 备注
	 */
	@Length(max = 200, message = "不能超过200个字符")
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Schema(description = "备注", name = "remark")
	private String remark;

	/**
	 * 0 是 1 否
	 */
	@Length(max = 1, message = "是否同步终止合同、减项、减档不能超过1个字符")
	@ExcelAttribute(name = "是否同步终止合同、减项、减档", maxLength = 1,readConverterExp = "0=是,1=否")
	@Schema(description = "是否同步终止合同、减项、减档", name = "changeContractAndEmployee")
	private String changeContractAndEmployee;
}
