package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/8/5
 * @Description
 * 派增：
 * 	 * 1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中1；
 * 	 * 2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金0；
 * 	 * 3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买 2
 * 	 * 4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常 3
 * 	 * 派减：
 * 	 * 1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；
 * 	 * 2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减 4
 * 	 * 人员档案处社保或公积金状态根据身份证+项目进行整合：
 * 	 * 社保状态优先级：正常>部分购买>处理中>已派减>无社保
 * 	 * 公积金状态优先级：正常>处理中>已派减>无公积金
 * @Version 1.0
 */
@Data
public class UpProjectSocialFundVo implements Serializable {
	/**
	 * @Author fxj
	 * @Description 社保状态 社保状态（字典）: 0 无社保 1 处理中 2.部分购买 3.正常 4.已派减
	**/
	@Schema(name = "社保状态（字典）: 0 无社保 1 处理中 2.部分购买 3.正常 4.已派减")
	String socialStatus;
	// 公积金状态 社保状态（字典）: 0 无社保 1 处理中 2.正常 3.已派减
	String fundStatus;
	// 项目编码
	String departNo;
	// 身份证
	String empIdCard;
	// 档案地-省
	String fileProvince;
	// 档案地-市
	String fileCity;
	// 档案地-县
	String fileTown;
	// 档案地-手机号码
	String mobile;
	//是否同步终止合同、减项、减档 0 是 1 否
	String changeContractAndEmployee;
	String userName;
	String userId;
	String empName;
	String deptName;
	String detailId;
    String contactAddress;
	String highEducation;
	/**
	 * 学校
	 */
	@Schema(description = "学校" )
	private String schoolName;

	/**
	 * 专业
	 */
	@Schema(description = "专业" )
	private String major;
	// 是否更新学历标识
	String flag;
}
